/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.renderer.world;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3i;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.ReflectionHelper;
import thefloydman.linkingbooks.client.renderer.world.SkyObjectDetails;
import thefloydman.linkingbooks.world.generation.AgeInfo;
import thefloydman.linkingbooks.world.generation.CloudInfo;
import thefloydman.linkingbooks.world.sky.SkyObject;
import thefloydman.linkingbooks.world.sky.SkyUtils;

@OnlyIn(value=Dist.CLIENT)
public class ModDimensionSpecialEffects {
    public static final Function<LevelRenderer, VertexBuffer> SKY_BUFFER = ReflectionHelper.getFieldGetter(LevelRenderer.class, "skyBuffer");
    public static final Function<LevelRenderer, VertexBuffer> STAR_BUFFER = ReflectionHelper.getFieldGetter(LevelRenderer.class, "starBuffer");
    public static final Function<LevelRenderer, VertexBuffer> DARK_BUFFER = ReflectionHelper.getFieldGetter(LevelRenderer.class, "darkBuffer");
    public static final Function<LevelRenderer, Boolean> GENERATE_CLOUDS_GETTER = ReflectionHelper.getFieldGetter(LevelRenderer.class, "generateClouds");
    public static final BiConsumer<LevelRenderer, Boolean> GENERATE_CLOUDS_SETTER = ReflectionHelper.getFieldSetter(LevelRenderer.class, "generateClouds");
    private static final ResourceLocation CLOUDS_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/clouds.png");

    @OnlyIn(value=Dist.CLIENT)
    public static class AgeEffects
    extends DimensionSpecialEffects {
        private final Map<CloudInfo, Vector3i> prevCloudPosMap = new HashMap<CloudInfo, Vector3i>();
        private final Map<CloudInfo, CloudStatus> prevCloudStatusMap = new HashMap<CloudInfo, CloudStatus>();
        private final Map<CloudInfo, Vec3> prevCloudColorMap = new HashMap<CloudInfo, Vec3>();
        private final Map<CloudInfo, VertexBuffer> cloudBuffers = new HashMap<CloudInfo, VertexBuffer>();

        public AgeEffects() {
            super(Float.NaN, true, DimensionSpecialEffects.SkyType.NONE, false, true);
        }

        @Nonnull
        public Vec3 getBrightnessDependentFogColor(@Nonnull Vec3 p_108901_, float p_108902_) {
            return p_108901_;
        }

        public boolean isFoggyAt(int x, int y) {
            return false;
        }

        public boolean renderSky(@Nonnull ClientLevel level, int ticks, float partialTicks, @Nonnull Matrix4f frustumMatrix, @Nonnull Camera camera, @Nonnull Matrix4f projectionMatrix, boolean isFoggy, @Nonnull Runnable setupFog) {
            AgeInfo ageInfo = Reference.AGE_INFO_MAP.get(level.dimension().location());
            if (ageInfo == null) {
                return false;
            }
            Minecraft minecraft = Minecraft.getInstance();
            PoseStack poseStack = new PoseStack();
            poseStack.mulPose(frustumMatrix);
            RenderSystem.depthMask((boolean)false);
            ShaderInstance shaderInstance = RenderSystem.getShader();
            if (shaderInstance == null) {
                return true;
            }
            if (ageInfo.overrideBiomeSkyColor()) {
                this.renderSkyMain(poseStack, ageInfo.skyColor());
            } else {
                Vec3 vec3 = level.getSkyColor(minecraft.gameRenderer.getMainCamera().getPosition(), partialTicks);
                Color skyColor = new Color((float)vec3.x, (float)vec3.y, (float)vec3.z);
                this.renderSkyMain(poseStack, skyColor.getRGB());
            }
            this.renderSkyObjects(ageInfo.skyObject(), level.getDayTime(), poseStack);
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
            return true;
        }

        private void renderSkyObjects(SkyObject mainSkyObject, long time, PoseStack poseStack) {
            List<SkyObjectDetails> allSkyObjectDetails = SkyUtils.generateSkyObjectDetails(mainSkyObject, time);
            for (SkyObjectDetails skyObjectDetails : allSkyObjectDetails) {
                RenderSystem.enableBlend();
                int color = skyObjectDetails.getSkyObject().hasColor() ? skyObjectDetails.getSkyObject().color() : Color.WHITE.getRGB();
                float radius = skyObjectDetails.getSkyObject().apparentRadius();
                float y = 100.0f;
                poseStack.pushPose();
                poseStack.mulPose(skyObjectDetails.getQuaternion());
                Matrix4f matrix4f = poseStack.last().pose();
                RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                ResourceLocation glowLocation = ResourceLocation.fromNamespaceAndPath((String)skyObjectDetails.getSkyObject().texture().getNamespace(), (String)(skyObjectDetails.getSkyObject().texture().getPath() + "_glow_black.png"));
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)glowLocation);
                BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
                bufferbuilder.addVertex(matrix4f, -radius, y, -radius).setUv(0.0f, 0.0f).setColor(color);
                bufferbuilder.addVertex(matrix4f, radius, y, -radius).setUv(1.0f, 0.0f).setColor(color);
                bufferbuilder.addVertex(matrix4f, radius, y, radius).setUv(1.0f, 1.0f).setColor(color);
                bufferbuilder.addVertex(matrix4f, -radius, y, radius).setUv(0.0f, 1.0f).setColor(color);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                ResourceLocation bodyLocation = ResourceLocation.fromNamespaceAndPath((String)skyObjectDetails.getSkyObject().texture().getNamespace(), (String)(skyObjectDetails.getSkyObject().texture().getPath() + "_body_trans.png"));
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)bodyLocation);
                bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
                bufferbuilder.addVertex(matrix4f, -radius, y, -radius).setUv(0.0f, 0.0f).setColor(color);
                bufferbuilder.addVertex(matrix4f, radius, y, -radius).setUv(1.0f, 0.0f).setColor(color);
                bufferbuilder.addVertex(matrix4f, radius, y, radius).setUv(1.0f, 1.0f).setColor(color);
                bufferbuilder.addVertex(matrix4f, -radius, y, radius).setUv(0.0f, 1.0f).setColor(color);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                poseStack.popPose();
                RenderSystem.disableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }

        private void renderSkyMain(PoseStack poseStack, int color) {
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Tesselator tesselator = Tesselator.getInstance();
            for (int i = 0; i < 6; ++i) {
                poseStack.pushPose();
                if (i == 1) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                }
                if (i == 2) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                }
                if (i == 3) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                }
                if (i == 4) {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                }
                if (i == 5) {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                }
                Matrix4f matrix4f = poseStack.last().pose();
                BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
                bufferbuilder.addVertex(matrix4f, -100.0f, -100.0f, -100.0f).setColor(color);
                bufferbuilder.addVertex(matrix4f, -100.0f, -100.0f, 100.0f).setColor(color);
                bufferbuilder.addVertex(matrix4f, 100.0f, -100.0f, 100.0f).setColor(color);
                bufferbuilder.addVertex(matrix4f, 100.0f, -100.0f, -100.0f).setColor(color);
                BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
                poseStack.popPose();
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }

        public boolean renderClouds(ClientLevel level, int ticks, float partialTick, @Nonnull PoseStack poseStack, double camX, double camY, double camZ, @Nonnull Matrix4f frustumMatrix, @Nonnull Matrix4f projectionMatrix) {
            AgeInfo ageInfo = Reference.AGE_INFO_MAP.get(level.dimension().location());
            if (ageInfo == null) {
                return false;
            }
            int tickOffset = 0;
            float speed = 0.02f;
            double zOffset = 0.0;
            for (CloudInfo cloudInfo : ageInfo.cloudInfos()) {
                VertexBuffer cloudBuffer;
                if (Float.isNaN(cloudInfo.height())) continue;
                Minecraft minecraft = Minecraft.getInstance();
                LevelRenderer levelRenderer = minecraft.levelRenderer;
                float f1 = 12.0f;
                float f2 = 4.0f;
                double d0 = 2.0E-4;
                double d1 = ((float)(ticks += tickOffset) + partialTick) * speed;
                double d2 = (camX + d1) / 12.0;
                double d3 = cloudInfo.height() - (float)camY + 0.33f;
                double d4 = camZ / 12.0 + 0.33 + zOffset;
                d2 -= (double)Mth.floor((double)(d2 / 2048.0)) * 2048.0;
                d4 -= (double)Mth.floor((double)(d4 / 2048.0)) * 2048.0;
                float f3 = (float)(d2 - (double)Mth.floor((double)d2));
                float f4 = (float)(d3 / 4.0 - (double)Mth.floor((double)(d3 / 4.0))) * 4.0f;
                float f5 = (float)(d4 - (double)Mth.floor((double)d4));
                Color color = new Color(cloudInfo.color());
                Vec3 vec3 = new Vec3((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
                int i = (int)Math.floor(d2);
                int j = (int)Math.floor(d3 / 4.0);
                int k = (int)Math.floor(d4);
                Vector3i prevCloudPos = this.prevCloudPosMap.getOrDefault(cloudInfo, new Vector3i(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE));
                CloudStatus prevCloudsType = this.prevCloudStatusMap.getOrDefault(cloudInfo, minecraft.options.getCloudsType());
                Vec3 prevCloudColor = this.prevCloudColorMap.getOrDefault(cloudInfo, Vec3.ZERO);
                if (i != prevCloudPos.x() || j != prevCloudPos.y() || k != prevCloudPos.z() || minecraft.options.getCloudsType() != prevCloudsType || prevCloudColor.distanceToSqr(vec3) > 2.0E-4) {
                    this.prevCloudPosMap.put(cloudInfo, new Vector3i(i, j, k));
                    this.prevCloudColorMap.put(cloudInfo, vec3);
                    this.prevCloudStatusMap.put(cloudInfo, minecraft.options.getCloudsType());
                    GENERATE_CLOUDS_SETTER.accept(levelRenderer, true);
                }
                if (GENERATE_CLOUDS_GETTER.apply(levelRenderer).booleanValue()) {
                    GENERATE_CLOUDS_SETTER.accept(levelRenderer, false);
                    cloudBuffer = this.cloudBuffers.get(cloudInfo);
                    if (cloudBuffer != null) {
                        cloudBuffer.close();
                    }
                    this.cloudBuffers.put(cloudInfo, new VertexBuffer(VertexBuffer.Usage.STATIC));
                    cloudBuffer = this.cloudBuffers.get(cloudInfo);
                    cloudBuffer.bind();
                    cloudBuffer.upload(this.buildClouds(Tesselator.getInstance(), d2, d3, d4, vec3, this.prevCloudStatusMap.getOrDefault(cloudInfo, Minecraft.getInstance().options.getCloudsType())));
                    VertexBuffer.unbind();
                }
                FogRenderer.levelFogColor();
                poseStack.pushPose();
                poseStack.mulPose(frustumMatrix);
                poseStack.scale(12.0f, 1.0f, 12.0f);
                poseStack.translate(-f3, f4, -f5);
                cloudBuffer = this.cloudBuffers.get(cloudInfo);
                if (cloudBuffer != null) {
                    int l;
                    cloudBuffer.bind();
                    for (int i1 = l = this.prevCloudStatusMap.getOrDefault(cloudInfo, minecraft.options.getCloudsType()) == CloudStatus.FANCY ? 0 : 1; i1 < 2; ++i1) {
                        RenderType renderType = i1 == 0 ? RenderType.cloudsDepthOnly() : RenderType.clouds();
                        renderType.setupRenderState();
                        ShaderInstance shaderInstance = RenderSystem.getShader();
                        if (shaderInstance != null) {
                            cloudBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, shaderInstance);
                        }
                        renderType.clearRenderState();
                    }
                    VertexBuffer.unbind();
                }
                poseStack.popPose();
                tickOffset += 2000;
                speed += 0.02f;
                zOffset += 97.0;
            }
            return true;
        }

        private MeshData buildClouds(Tesselator tesselator, double x, double y, double z, Vec3 cloudColor, CloudStatus cloudStatus) {
            float f = 4.0f;
            float f1 = 0.00390625f;
            int i = 8;
            int j = 4;
            float f2 = 9.765625E-4f;
            float f3 = (float)Mth.floor((double)x) * 0.00390625f;
            float f4 = (float)Mth.floor((double)z) * 0.00390625f;
            float f5 = (float)cloudColor.x;
            float f6 = (float)cloudColor.y;
            float f7 = (float)cloudColor.z;
            float f8 = f5 * 0.9f;
            float f9 = f6 * 0.9f;
            float f10 = f7 * 0.9f;
            float f11 = f5 * 0.7f;
            float f12 = f6 * 0.7f;
            float f13 = f7 * 0.7f;
            float f14 = f5 * 0.8f;
            float f15 = f6 * 0.8f;
            float f16 = f7 * 0.8f;
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR_NORMAL);
            float f17 = (float)Math.floor(y / 4.0) * 4.0f;
            if (cloudStatus == CloudStatus.FANCY) {
                for (int k = -3; k <= 4; ++k) {
                    for (int l = -3; l <= 4; ++l) {
                        float f18 = k * 8;
                        float f19 = l * 8;
                        if (f17 > -5.0f) {
                            bufferbuilder.addVertex(f18 + 0.0f, f17 + 0.0f, f19 + 8.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f11, f12, f13, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                            bufferbuilder.addVertex(f18 + 8.0f, f17 + 0.0f, f19 + 8.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f11, f12, f13, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                            bufferbuilder.addVertex(f18 + 8.0f, f17 + 0.0f, f19 + 0.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f11, f12, f13, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                            bufferbuilder.addVertex(f18 + 0.0f, f17 + 0.0f, f19 + 0.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f11, f12, f13, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                        }
                        if (f17 <= 5.0f) {
                            bufferbuilder.addVertex(f18 + 0.0f, f17 + 4.0f - 9.765625E-4f, f19 + 8.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                            bufferbuilder.addVertex(f18 + 8.0f, f17 + 4.0f - 9.765625E-4f, f19 + 8.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                            bufferbuilder.addVertex(f18 + 8.0f, f17 + 4.0f - 9.765625E-4f, f19 + 0.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                            bufferbuilder.addVertex(f18 + 0.0f, f17 + 4.0f - 9.765625E-4f, f19 + 0.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                        }
                        if (k > -1) {
                            for (int i1 = 0; i1 < 8; ++i1) {
                                bufferbuilder.addVertex(f18 + (float)i1 + 0.0f, f17 + 0.0f, f19 + 8.0f).setUv((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                                bufferbuilder.addVertex(f18 + (float)i1 + 0.0f, f17 + 4.0f, f19 + 8.0f).setUv((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                                bufferbuilder.addVertex(f18 + (float)i1 + 0.0f, f17 + 4.0f, f19 + 0.0f).setUv((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                                bufferbuilder.addVertex(f18 + (float)i1 + 0.0f, f17 + 0.0f, f19 + 0.0f).setUv((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                            }
                        }
                        if (k <= 1) {
                            for (int j2 = 0; j2 < 8; ++j2) {
                                bufferbuilder.addVertex(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 0.0f, f19 + 8.0f).setUv((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                                bufferbuilder.addVertex(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 4.0f, f19 + 8.0f).setUv((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                                bufferbuilder.addVertex(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 4.0f, f19 + 0.0f).setUv((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                                bufferbuilder.addVertex(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 0.0f, f19 + 0.0f).setUv((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                            }
                        }
                        if (l > -1) {
                            for (int k2 = 0; k2 < 8; ++k2) {
                                bufferbuilder.addVertex(f18 + 0.0f, f17 + 4.0f, f19 + (float)k2 + 0.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                                bufferbuilder.addVertex(f18 + 8.0f, f17 + 4.0f, f19 + (float)k2 + 0.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                                bufferbuilder.addVertex(f18 + 8.0f, f17 + 0.0f, f19 + (float)k2 + 0.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                                bufferbuilder.addVertex(f18 + 0.0f, f17 + 0.0f, f19 + (float)k2 + 0.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                            }
                        }
                        if (l > 1) continue;
                        for (int l2 = 0; l2 < 8; ++l2) {
                            bufferbuilder.addVertex(f18 + 0.0f, f17 + 4.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                            bufferbuilder.addVertex(f18 + 8.0f, f17 + 4.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                            bufferbuilder.addVertex(f18 + 8.0f, f17 + 0.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                            bufferbuilder.addVertex(f18 + 0.0f, f17 + 0.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                        }
                    }
                }
            } else {
                boolean j1 = true;
                int k1 = 32;
                for (int l1 = -32; l1 < 32; l1 += 32) {
                    for (int i2 = -32; i2 < 32; i2 += 32) {
                        bufferbuilder.addVertex((float)(l1 + 0), f17, (float)(i2 + 32)).setUv((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                        bufferbuilder.addVertex((float)(l1 + 32), f17, (float)(i2 + 32)).setUv((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                        bufferbuilder.addVertex((float)(l1 + 32), f17, (float)(i2 + 0)).setUv((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                        bufferbuilder.addVertex((float)(l1 + 0), f17, (float)(i2 + 0)).setUv((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    }
                }
            }
            return bufferbuilder.buildOrThrow();
        }
    }
}

