/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.linking.LinkEffect;

public record LinkData(@Nonnull ResourceLocation dimension, @Nonnull BlockPos blockPos, float rotation, @Nonnull UUID uuid, @Nonnull List<ResourceLocation> linkEffects) {
    public static final Codec<LinkData> CODEC = RecordCodecBuilder.create(codecBuilderInstance -> codecBuilderInstance.group((App)ResourceLocation.CODEC.fieldOf("dimension").forGetter(LinkData::dimension), (App)BlockPos.CODEC.fieldOf("blockpos").forGetter(LinkData::blockPos), (App)Codec.FLOAT.fieldOf("rotation").forGetter(LinkData::rotation), (App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(LinkData::uuid), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("linkeffects").forGetter(LinkData::linkEffects)).apply((Applicative)codecBuilderInstance, LinkData::new));
    public static final StreamCodec<ByteBuf, LinkData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, LinkData::dimension, (StreamCodec)BlockPos.STREAM_CODEC, LinkData::blockPos, (StreamCodec)ByteBufCodecs.FLOAT, LinkData::rotation, (StreamCodec)UUIDUtil.STREAM_CODEC, LinkData::uuid, (StreamCodec)ByteBufCodecs.fromCodec((Codec)Codec.list((Codec)ResourceLocation.CODEC)), LinkData::linkEffects, LinkData::new);
    public static final LinkData EMPTY = new LinkData(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"overworld"), BlockPos.ZERO, 0.0f, UUID.randomUUID(), new ArrayList<ResourceLocation>());

    public static LinkData fromPlayer(Player player) {
        return new LinkData(player.getCommandSenderWorld().dimension().location(), player.blockPosition(), player.getYRot(), UUID.randomUUID(), new ArrayList<ResourceLocation>());
    }

    public Set<LinkEffect> linkEffectsAsLE() {
        return this.linkEffects.stream().map(LinkEffect::getLinkEffect).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @OnlyIn(value=Dist.CLIENT)
    public Set<LinkEffect> linkEffectsAsLE(Minecraft minecraft) {
        return this.linkEffects.stream().map(arg_0 -> ((Registry)((Registry)minecraft.getConnection().registryAccess().registry(LinkEffect.REGISTRY_KEY).get())).get(arg_0)).collect(Collectors.toSet());
    }

    @Nonnull
    public Component dimensionName() {
        if (this.dimension().getPath().startsWith("relto")) {
            try {
                Pattern regExPattern = Pattern.compile("^relto_(.*)$");
                Matcher regExMatcher = regExPattern.matcher(this.dimension().getPath());
                if (regExMatcher.find()) {
                    String uuidString = regExMatcher.group(1);
                    String ownerUsername = Reference.PLAYER_DISPLAY_NAMES.get(UUID.fromString(uuidString));
                    return ownerUsername == null ? Component.translatable((String)"age.linkingbooks.name.relto") : Component.translatable((String)"age.linkingbooks.name.relto", (Object[])new Object[]{ownerUsername});
                }
            }
            catch (IllegalStateException | IndexOutOfBoundsException | PatternSyntaxException e) {
                LogUtils.getLogger().error(e.getMessage());
            }
        }
        return Component.translatable((String)("age." + this.dimension().getNamespace() + ".name." + this.dimension().getPath()));
    }
}

