/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.entity;

import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ObjectEntity
extends Entity {
    private static final EntityDataAccessor<Float> DURABILITY = SynchedEntityData.defineId(ObjectEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(ObjectEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final String LABEL_DURABILITY = "Durability";
    private static final String LABEL_ITEM = "Item";
    private static final String LABEL_HURTTIME = "HurtTime";
    private final Class<? extends Item> itemClass;
    private final float maxDurability;
    public int hurtTime;

    public ObjectEntity(EntityType<? extends ObjectEntity> type, Level world, Class<? extends Item> itemClass, float maxDurability) {
        super(type, world);
        this.itemClass = itemClass;
        this.maxDurability = maxDurability;
        this.setDurability(this.getMaxDurability());
        this.hurtTime = 0;
    }

    public ObjectEntity(EntityType<? extends ObjectEntity> type, Level world, Class<? extends Item> itemClass, float maxDurability, ItemStack item) {
        this(type, world, itemClass, maxDurability);
        this.setItem(item);
    }

    protected void defineSynchedData(@Nonnull SynchedEntityData.Builder pBuilder) {
        pBuilder.define(DURABILITY, (Object)Float.valueOf(1.0f));
        pBuilder.define(ITEM, (Object)ItemStack.EMPTY);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains(LABEL_DURABILITY, 99)) {
            this.setDurability(compound.getFloat(LABEL_DURABILITY));
        }
        if (compound.contains(LABEL_ITEM, 10)) {
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compound.getCompound(LABEL_ITEM));
            if (this.itemClass.isInstance(stack.getItem())) {
                this.setItem(stack);
            } else {
                this.setItem(ItemStack.EMPTY);
            }
        }
        this.hurtTime = compound.getShort(LABEL_HURTTIME);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(LABEL_DURABILITY, this.getDurability());
        compound.put(LABEL_ITEM, this.getItem().save((HolderLookup.Provider)this.registryAccess()));
        compound.putShort(LABEL_HURTTIME, (short)this.hurtTime);
    }

    public final float getMaxDurability() {
        return this.maxDurability;
    }

    public float getDurability() {
        return ((Float)this.entityData.get(DURABILITY)).floatValue();
    }

    public void setDurability(float health) {
        this.entityData.set(DURABILITY, (Object)Float.valueOf(Mth.clamp((float)health, (float)0.0f, (float)this.getMaxDurability())));
    }

    public ItemStack getItem() {
        return (ItemStack)this.entityData.get(ITEM);
    }

    public void setItem(ItemStack item) {
        this.entityData.set(ITEM, (Object)item);
    }

    public boolean hurt(DamageSource source, float amount) {
        this.hurtTime = 10;
        this.setDurability(this.getDurability() - amount);
        return super.hurt(source, amount);
    }

    public void baseTick() {
        super.baseTick();
        if (this.getItem().isEmpty() || this.getDurability() <= 0.0f) {
            this.onKilled();
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        Vec3 vec3d = this.getDeltaMovement();
        double d1 = vec3d.x;
        double d3 = vec3d.y;
        double d5 = vec3d.z;
        if (this.onGround()) {
            d1 *= 0.8;
            d5 *= 0.8;
        }
        if (Math.abs(vec3d.x) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vec3d.y) < 0.003) {
            d3 = 0.0;
        }
        if (Math.abs(vec3d.z) < 0.003) {
            d5 = 0.0;
        }
        this.setDeltaMovement(d1, d3, d5);
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public void onKilled() {
        this.kill();
    }

    public void playerTouch(Player player) {
        if ((double)this.distanceTo((Entity)player) < 0.75) {
            player.push((Entity)this);
        }
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public boolean isPushable() {
        return this.isAlive();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 256.0 * ObjectEntity.getViewScale()) * d0;
    }
}

