/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.integration;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.render.GuiPortalRendering;
import qouteall.imm_ptl.core.render.PortalEntityRenderer;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import thefloydman.linkingbooks.LinkingBooksConfig;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.blockentity.LinkTranslatorBlockEntity;
import thefloydman.linkingbooks.client.ImageUtils;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.component.ModDataComponents;
import thefloydman.linkingbooks.entity.LinkingPortalEntity;
import thefloydman.linkingbooks.item.ModItems;

public final class ImmersivePortalsIntegration {
    private static final WeakHashMap<ServerPlayer, ChunkLoader> CHUNK_LOADERS = new WeakHashMap();
    public static final EntityType<LinkingPortalEntity> LINKING_PORTAL_ENTITY_TYPE = EntityType.Builder.of(LinkingPortalEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).setTrackingRange(96).fireImmune().build("linkingbooks:linking_portal");

    public static void addChunkLoader(LinkData linkData, ServerPlayer player) {
        ImmersivePortalsIntegration.removeChunkLoader(player);
        ChunkLoader chunkLoader = new ChunkLoader(new DimensionalChunkPos(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)linkData.dimension()), new ChunkPos(linkData.blockPos())), ((Integer)LinkingBooksConfig.LINKING_PANEL_CHUNK_LOAD_RADIUS.get()).intValue());
        PortalAPI.addChunkLoaderForPlayer((ServerPlayer)player, (ChunkLoader)chunkLoader);
        CHUNK_LOADERS.put(player, chunkLoader);
    }

    public static void removeChunkLoader(ServerPlayer player) {
        ChunkLoader chunkLoader = CHUNK_LOADERS.remove(player);
        if (chunkLoader != null) {
            PortalAPI.removeChunkLoaderForPlayer((ServerPlayer)player, (ChunkLoader)chunkLoader);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderGuiPortal(LinkData linkData, RenderTarget renderTarget, Minecraft client, int x, int y, int width, int height) {
        Matrix4f cameraTransformation = new Matrix4f();
        cameraTransformation.identity();
        cameraTransformation.mul((Matrix4fc)Axis.YP.rotationDegrees(linkData.rotation() + 180.0f).get(new Matrix4f()));
        WorldRenderInfo.Builder worldRenderInfoBuilder = new WorldRenderInfo.Builder();
        worldRenderInfoBuilder.setWorld(ClientWorldLoader.getWorld((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)linkData.dimension())));
        worldRenderInfoBuilder.setCameraPos(new Vec3((double)linkData.blockPos().getX() + 0.5, (double)linkData.blockPos().getY() + 1.5, (double)linkData.blockPos().getZ() + 0.5));
        worldRenderInfoBuilder.setCameraTransformation(cameraTransformation);
        worldRenderInfoBuilder.setRenderDistance(((Integer)LinkingBooksConfig.LINKING_PANEL_CHUNK_LOAD_RADIUS.get()).intValue());
        WorldRenderInfo worldRenderInfo = worldRenderInfoBuilder.build();
        GuiPortalRendering.submitNextFrameRendering((WorldRenderInfo)worldRenderInfo, (RenderTarget)renderTarget);
        TextureTarget smallerRenderTarget = new TextureTarget(width, height, true, false);
        ImageUtils.cropShrinkCenterRenderTarget(renderTarget, (RenderTarget)smallerRenderTarget, width, height, true, false, false, true);
        ImageUtils.drawRenderTarget((RenderTarget)smallerRenderTarget, true, false, (int)((double)x * client.getWindow().getGuiScale()), (int)((double)y * client.getWindow().getGuiScale()), (int)((double)width * client.getWindow().getGuiScale()), (int)((double)height * client.getWindow().getGuiScale()));
        smallerRenderTarget.clear(true);
    }

    public static UUID[] addImmersivePortal(Level world, double[] pos, double width, double height, Set<BlockPos> coveredBlocks, Direction.Axis axis, LinkData linkData, LinkTranslatorBlockEntity tileEntity) {
        if (axis == Direction.Axis.X) {
            axis = Direction.Axis.Z;
        } else if (axis == Direction.Axis.Z) {
            axis = Direction.Axis.X;
        }
        LinkData itemData = new LinkData(linkData.dimension(), linkData.blockPos(), linkData.rotation(), linkData.uuid(), linkData.linkEffects());
        ItemStack stack = ModItems.WRITTEN_LINKING_BOOK.toStack();
        stack.set(ModDataComponents.LINK_DATA, (Object)itemData);
        LinkingPortalEntity portal = new LinkingPortalEntity(LINKING_PORTAL_ENTITY_TYPE, world, stack, tileEntity.getBlockPos());
        portal.setPos(pos[0], pos[1], pos[2]);
        BlockPortalShape shape = new BlockPortalShape(coveredBlocks, axis);
        shape.initPortalPosAxisShape((Portal)portal, Direction.AxisDirection.POSITIVE);
        PortalManipulation.setPortalTransformation((Portal)portal, (ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)linkData.dimension()), (Vec3)new Vec3((double)linkData.blockPos().getX() + 0.5, (double)linkData.blockPos().getY() + height / 2.0 + (axis == Direction.Axis.Y ? 2.0 : 0.0) + 0.5, (double)linkData.blockPos().getZ() + 0.5), null, (double)1.0);
        PortalManipulation.removeOverlappedPortals((Level)world, (Vec3)portal.position(), (Vec3)portal.getNormal(), p -> p instanceof LinkingPortalEntity, p -> {});
        world.addFreshEntity((Entity)portal);
        LinkingPortalEntity reversePortal = (LinkingPortalEntity)PortalManipulation.createFlippedPortal((Portal)portal, LINKING_PORTAL_ENTITY_TYPE);
        reversePortal.setTileEntityPos(portal.getTileEntityPos());
        PortalManipulation.removeOverlappedPortals((Level)world, (Vec3)reversePortal.position(), (Vec3)reversePortal.getNormal(), p -> p instanceof LinkingPortalEntity, p -> {});
        world.addFreshEntity((Entity)reversePortal);
        return new UUID[]{portal.getUUID(), reversePortal.getUUID()};
    }

    public static void registerImmersivePortalsEntities(RegisterEvent event) {
        event.register(Registries.ENTITY_TYPE, registry -> registry.register(Reference.getAsResourceLocation("linking_portal"), LINKING_PORTAL_ENTITY_TYPE));
    }

    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(LINKING_PORTAL_ENTITY_TYPE, PortalEntityRenderer::new);
    }

    public static List<LinkingPortalEntity> getNearbyLinkingPortals(BlockPos pos, Level level) {
        return level.getEntitiesOfClass(LinkingPortalEntity.class, new AABB(pos.below(64).south(64).west(64).getCenter(), pos.above(64).north(64).east(64).getCenter()), Objects::nonNull);
    }

    public static void deleteLinkingPortals(LinkTranslatorBlockEntity blockEntity) {
        List<LinkingPortalEntity> nearbyPortals = ImmersivePortalsIntegration.getNearbyLinkingPortals(blockEntity.getBlockPos(), blockEntity.getLevel());
        for (LinkingPortalEntity portal : nearbyPortals) {
            if (!portal.getTileEntityPos().equals((Object)blockEntity.getBlockPos())) continue;
            portal.remove(Entity.RemovalReason.DISCARDED);
        }
    }
}

