/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.item;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.component.ModDataComponents;
import thefloydman.linkingbooks.entity.LinkingBookEntity;
import thefloydman.linkingbooks.linking.LinkingUtils;

public class WrittenLinkingBookItem
extends Item {
    public WrittenLinkingBookItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        LinkData linkData;
        ItemStack heldStack = player.getItemInHand(hand);
        if (!world.isClientSide() && !player.isShiftKeyDown() && (linkData = (LinkData)heldStack.get(ModDataComponents.LINK_DATA)) != null) {
            LinkingUtils.openLinkingBookGui((ServerPlayer)player, true, LinkingUtils.getLinkingBookColor(heldStack, 0), linkData, world.dimension().location());
        }
        return InteractionResultHolder.pass((Object)heldStack);
    }

    public Entity createEntity(@Nonnull Level world, Entity itemEntity, ItemStack stack) {
        LinkingBookEntity entity = new LinkingBookEntity(world, stack.copy());
        entity.setPos(itemEntity.getX(), itemEntity.getY(), itemEntity.getZ());
        entity.setYRot(itemEntity.getYRot());
        entity.setDeltaMovement(itemEntity.getDeltaMovement());
        return entity;
    }

    public boolean hasCustomEntity(@Nonnull ItemStack stack) {
        return true;
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext tooltipContext, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.appendHoverText(stack, tooltipContext, tooltip, flag);
        LinkData linkData = (LinkData)stack.get(ModDataComponents.LINK_DATA);
        if (linkData != null) {
            tooltip.add((Component)Component.translatable((String)"\u00a7eAge: \u00a79\u00a7o%s", (Object[])new Object[]{linkData.dimensionName()}));
            tooltip.add((Component)Component.literal((String)("\u00a7eCoordinates: \u00a79\u00a7o(" + linkData.blockPos().getX() + ", " + linkData.blockPos().getY() + ", " + linkData.blockPos().getZ() + ")")));
            HashSet<ResourceLocation> linkEffects = new HashSet<ResourceLocation>(linkData.linkEffects());
            if (!linkEffects.isEmpty()) {
                tooltip.add((Component)Component.literal((String)"\u00a7eLink Effects:"));
                for (ResourceLocation effect : linkEffects) {
                    tooltip.add((Component)Component.literal((String)("    \u00a79\u00a7o" + Component.translatable((String)("linkEffect." + effect.getNamespace() + "." + effect.getPath())).getString())));
                }
            }
        }
    }
}

