/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.linking;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.FileUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thefloydman.linkingbooks.LinkingBooksConfig;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.client.sound.ModSounds;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.component.ModDataComponents;
import thefloydman.linkingbooks.entity.LinkingBookEntity;
import thefloydman.linkingbooks.item.ModItems;
import thefloydman.linkingbooks.item.ReltoBookItem;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;
import thefloydman.linkingbooks.linking.LinkEffect;
import thefloydman.linkingbooks.menutype.LinkingBookMenuType;
import thefloydman.linkingbooks.menutype.ReltoBookMenuType;
import thefloydman.linkingbooks.network.client.PlayOwnLinkingSoundMessage;
import thefloydman.linkingbooks.network.client.TakeScreenshotForLinkingBookMessage;
import thefloydman.linkingbooks.world.generation.AgeUtils;
import thefloydman.linkingbooks.world.generation.CloudInfo;
import thefloydman.linkingbooks.world.generation.LinkingBooksDimensionFactory;
import thefloydman.linkingbooks.world.sky.SkyObject;
import thefloydman.linkingbooks.world.storage.LinkingBooksSavedData;

public class LinkingUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static ItemStack createWrittenLinkingBook(Player player, ItemStack originItem) {
        LinkData linkData = LinkData.fromPlayer(player);
        ItemStack writtenBook = ((WrittenLinkingBookItem)((Object)ModItems.WRITTEN_LINKING_BOOK.get())).getDefaultInstance();
        writtenBook.set(ModDataComponents.LINK_DATA, (Object)linkData);
        writtenBook.set(DataComponents.DYED_COLOR, (Object)((DyedItemColor)originItem.getOrDefault(DataComponents.DYED_COLOR, (Object)new DyedItemColor(new Color(181, 134, 83).getRGB(), false))));
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new TakeScreenshotForLinkingBookMessage(linkData.uuid()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return writtenBook;
    }

    public static boolean linkEntity(Entity entity, LinkData linkData, boolean holdingBook) {
        Level level = entity.getCommandSenderWorld();
        if (level.isClientSide()) {
            LOGGER.info("An attempt has been made to directly link an entity from the client. Only do this from the server.");
        } else if (linkData == null) {
            LOGGER.info("A null ILinkInfo has been supplied. Link failed.");
        } else if (!((Boolean)LinkingBooksConfig.ALWAYS_ALLOW_INTRAAGE_LINKING.get()).booleanValue() && !linkData.linkEffects().contains(ResourceLocation.parse((String)"linkingbooks:intraage_linking")) && level.dimension().location().equals((Object)linkData.dimension())) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.closeContainer();
                player.doCloseContainer();
                player.displayClientMessage((Component)Component.translatable((String)"message.linkingbooks.no_intraage_linking"), true);
            }
        } else {
            MinecraftServer server = level.getServer();
            if (server == null) {
                LOGGER.info("Cannot get Minecraft server instance. Link failed.");
                return false;
            }
            ServerLevel serverWorld = server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)linkData.dimension()));
            if (serverWorld == null) {
                LOGGER.info("Cannot find dimension \"{}\". Link failed.", (Object)linkData.dimension());
                return false;
            }
            Set<LinkEffect> linkEffects = linkData.linkEffectsAsLE();
            for (LinkEffect effect : linkEffects) {
                if (effect.canStartLink().apply(entity, linkData).booleanValue()) continue;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    player.closeContainer();
                    player.doCloseContainer();
                    player.displayClientMessage((Component)Component.translatable((String)"message.linkingbooks.link_failed_start"), true);
                }
                return false;
            }
            for (LinkEffect effect : linkEffects) {
                effect.onLinkStart().accept(entity, linkData);
            }
            Vec3 originalPos = entity.position();
            float originalRot = entity.getYRot();
            BlockPos pos = linkData.blockPos();
            double x = (double)pos.getX() + 0.5;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.5;
            float rotation = linkData.rotation();
            boolean tookExperience = false;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (!player.isCreative()) {
                    if (player.experienceLevel < (Integer)LinkingBooksConfig.LINKING_COST_LEVELS.get()) {
                        player.closeContainer();
                        player.doCloseContainer();
                        player.displayClientMessage((Component)Component.translatable((String)"message.linkingbooks.insufficient_experience"), true);
                        return false;
                    }
                    player.giveExperienceLevels((Integer)LinkingBooksConfig.LINKING_COST_LEVELS.get() * -1);
                    tookExperience = true;
                }
                if (holdingBook && !linkData.linkEffects().contains(Reference.getAsResourceLocation("tethered"))) {
                    LinkingBookEntity book = new LinkingBookEntity(level, player.getMainHandItem().copy());
                    Vec3 lookVec = player.getLookAngle();
                    book.setPos(player.getX() + lookVec.x() / 4.0, player.getY() + 1.0, player.getZ() + lookVec.z() / 4.0);
                    book.setYRot(player.yHeadRot);
                    level.addFreshEntity((Entity)book);
                    player.getMainHandItem().shrink(1);
                }
                player.doCloseContainer();
                player.closeContainer();
                serverWorld.playSound((Player)player, player.blockPosition(), ModSounds.LINK.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
                player.teleportTo(serverWorld, x, y, z, rotation, player.getXRot());
                player.resetFallDistance();
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PlayOwnLinkingSoundMessage(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                CompoundTag nbt = new CompoundTag();
                entity.saveAsPassenger(nbt);
                entity.remove(Entity.RemovalReason.CHANGED_DIMENSION);
                Entity entityCopy = EntityType.create((CompoundTag)nbt, (Level)serverWorld).orElse(null);
                if (entityCopy == null) {
                    return false;
                }
                entityCopy.setPos(x, y, z);
                serverWorld.addFreshEntity(entityCopy);
                serverWorld.addDuringTeleport(entityCopy);
            }
            for (LinkEffect effect : linkEffects) {
                if (effect.canFinishLink().apply(entity, linkData).booleanValue()) continue;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    if (tookExperience) {
                        player.giveExperienceLevels(((Integer)LinkingBooksConfig.LINKING_COST_LEVELS.get()).intValue());
                    }
                    serverWorld.getServer().execute(() -> {
                        player.teleportTo((ServerLevel)level, originalPos.x, originalPos.y, originalPos.z, originalRot, player.getXRot());
                        player.displayClientMessage((Component)Component.translatable((String)"message.linkingbooks.link_failed_end"), true);
                    });
                } else {
                    serverWorld.getServer().execute(() -> {
                        CompoundTag tag = new CompoundTag();
                        entity.saveAsPassenger(tag);
                        entity.remove(Entity.RemovalReason.CHANGED_DIMENSION);
                        Entity entityCopy = EntityType.create((CompoundTag)tag, (Level)level).orElse(null);
                        if (entityCopy != null) {
                            entityCopy.setPos(originalPos.x, originalPos.y, originalPos.z);
                            level.addFreshEntity(entityCopy);
                            ((ServerLevel)level).addDuringTeleport(entityCopy);
                        }
                    });
                }
                return false;
            }
            for (LinkEffect effect : linkEffects) {
                effect.onLinkEnd().accept(entity, linkData);
            }
            return true;
        }
        return false;
    }

    public static int linkEntities(List<Entity> entities, LinkData linkData, boolean holdingBook) {
        int linked = 0;
        for (Entity entity : entities) {
            linked += LinkingUtils.linkEntity(entity, linkData, holdingBook) ? 1 : 0;
        }
        return linked;
    }

    public static int linkToRelto(ServerPlayer player, UUID reltoOwner) {
        ResourceLocation ageResourceLocation = Reference.getAsResourceLocation(String.format("relto_%s", reltoOwner));
        SkyObject self = SkyObject.self(0, 12000L, 0.7853982f, 0x2EE000L, 0.0f, 1.0f, List.of());
        SkyObject innerPlanet = new SkyObject(Reference.getAsResourceLocation("inner_planet"), 0, Reference.getAsResourceLocation("textures/environment/sun"), 0L, 0.0f, 24000L, 0.0f, 0.25f, 5.0f, true, new Color(182, 182, 182).getRGB(), List.of());
        SkyObject sun = new SkyObject(Reference.getAsResourceLocation("sun"), 15, Reference.getAsResourceLocation("textures/environment/sun"), 0L, 0.0f, 0L, 0.0f, 0.0f, 30.0f, true, new Color(255, 245, 138).getRGB(), List.of(self, innerPlanet));
        Pair<ServerLevel, Boolean> levelPair = AgeUtils.getOrCreateLevel(player.server, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ageResourceLocation), (Component)Component.translatable((String)"age.linkingbooks.name.relto"), reltoOwner, true, new Color(69, 7, 94).getRGB(), new Color(54, 42, 133).getRGB(), sun, List.of(new CloudInfo(193.0f, new Color(191, 48, 0).getRGB()), new CloudInfo(188.0f, new Color(107, 29, 3).getRGB()), new CloudInfo(183.0f, new Color(84, 0, 0).getRGB())), (TriFunction<MinecraftServer, ResourceKey<LevelStem>, ResourceKey<DimensionType>, LevelStem>)((TriFunction)LinkingBooksDimensionFactory::createRelto));
        if (((Boolean)levelPair.getSecond()).booleanValue()) {
            LinkingUtils.copyRegionFiles(ageResourceLocation);
        }
        LinkData linkData = new LinkData(ageResourceLocation, new BlockPos(-11, 200, 23), -180.0f, UUID.randomUUID(), List.of(Reference.getAsResourceLocation("intraage_linking")));
        return LinkingUtils.linkEntities(Lists.newArrayList((Object[])new Entity[]{player}), linkData, false);
    }

    public static void openLinkingBookGui(ServerPlayer serverPlayer, boolean holdingBook, int color, LinkData linkData, ResourceLocation currentDimension) {
        MinecraftServer server = serverPlayer.getServer();
        if (server != null) {
            serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerEntity) -> new LinkingBookMenuType(id, playerInventory), (Component)Component.literal((String)"")), extraData -> {
                extraData.writeBoolean(holdingBook);
                extraData.writeInt(color);
                extraData.writeJsonWithCodec(LinkData.CODEC, (Object)linkData);
                boolean canLink = (Boolean)LinkingBooksConfig.ALWAYS_ALLOW_INTRAAGE_LINKING.get() != false || !currentDimension.equals((Object)linkData.dimension()) || linkData.linkEffects().contains(Reference.getAsResourceLocation("intraage_linking"));
                extraData.writeBoolean(canLink);
                extraData.writeBoolean(AgeUtils.levelExists(server, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)linkData.dimension())));
                ServerLevel overworld = server.overworld();
                LinkingBooksSavedData savedData = (LinkingBooksSavedData)overworld.getDataStorage().computeIfAbsent(LinkingBooksSavedData.factory(), "linkingbooks");
                extraData.writeNbt((Tag)savedData.getLinkingPanelImage(linkData.uuid()));
            });
        }
    }

    public static void openReltoBookGui(ServerPlayer serverPlayer, UUID owner) {
        MinecraftServer server = serverPlayer.getServer();
        if (server != null) {
            serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerEntity) -> new ReltoBookMenuType(id, playerInventory), (Component)Component.literal((String)"")), extraData -> {
                extraData.writeUUID(owner);
                extraData.writeBoolean(AgeUtils.levelExists(server, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)Reference.getAsResourceLocation(String.format("relto_%s", owner)))));
            });
        }
    }

    public static int getLinkingBookColor(ItemStack stack, int tintIndex) {
        if (tintIndex != 0) {
            return -1;
        }
        if (stack.getItem() instanceof ReltoBookItem) {
            return new Color(77, 196, 109).getRGB();
        }
        DyedItemColor dyedColor = (DyedItemColor)stack.getOrDefault(DataComponents.DYED_COLOR, (Object)new DyedItemColor(new Color(181, 134, 83).getRGB(), false));
        return dyedColor.rgb();
    }

    private static void copyRegionFiles(ResourceLocation ageResourceLocation) {
        Path reltoRegionPath = Reference.server.getWorldPath(new LevelResource("dimensions/linkingbooks/" + ageResourceLocation.getPath() + "/region"));
        try {
            FileUtil.createDirectoriesSafe((Path)reltoRegionPath);
            IModFile modFile = ModList.get().getModFileById("linkingbooks").getFile();
            Path examples = modFile.findResource(new String[]{"data/linkingbooks/linkingbooks/agetemplate/relto"});
            Stream<Path> paths = Files.list(examples);
            List<Path> pathList = paths.filter(fromPath -> fromPath.toString().endsWith(".mca")).toList();
            for (Path fromPath2 : pathList) {
                Path toPath = reltoRegionPath.resolve(fromPath2.getFileName().toString());
                Files.copy(fromPath2, toPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not prefill dimension {}", (Object)ageResourceLocation.getPath());
        }
    }
}

