/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.blockentity.LinkTranslatorBlockEntity;
import thefloydman.linkingbooks.blockentity.ModBlockEntityTypes;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.component.ModDataComponents;
import thefloydman.linkingbooks.entity.LinkingBookEntity;
import thefloydman.linkingbooks.integration.ImmersivePortalsIntegration;
import thefloydman.linkingbooks.item.ReltoBookItem;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;
import thefloydman.linkingbooks.linking.LinkingPortalArea;
import thefloydman.linkingbooks.linking.LinkingUtils;

public class LinkTranslatorBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty HAS_BOOK = BlockStateProperties.HAS_BOOK;
    public static final MapCodec<LinkTranslatorBlock> CODEC = LinkTranslatorBlock.simpleCodec(LinkTranslatorBlock::new);
    public static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)1.0), Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)4.0, (double)2.0), Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)12.0, (double)1.0, (double)16.0, (double)16.0, (double)2.0)});
    public static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)15.0, (double)4.0, (double)16.0), Block.box((double)15.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)12.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0)});
    public static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)5.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)4.0, (double)15.0), Block.box((double)0.0, (double)11.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0, (double)15.0)});
    public static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)5.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)0.0, (double)2.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)11.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)12.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0)});

    protected LinkTranslatorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_BOOK, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HAS_BOOK});
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ModBlockEntityTypes.LINK_TRANSLATOR.get().create(pos, state);
    }

    public void setPlacedBy(@Nonnull Level world, @Nonnull BlockPos blockPos, @Nonnull BlockState blockState, LivingEntity livingEntity, @Nonnull ItemStack itemStack) {
        super.setPlacedBy(world, blockPos, blockState, livingEntity, itemStack);
        for (int x = blockPos.getX() - 32; x < blockPos.getX() + 32; ++x) {
            for (int y = blockPos.getY() - 32; y < blockPos.getY() + 32; ++y) {
                for (int z = blockPos.getZ() - 32; z < blockPos.getZ() + 32; ++z) {
                    LinkTranslatorBlockEntity translator;
                    BlockPos currentPos = new BlockPos(x, y, z);
                    BlockEntity blockEntity = world.getBlockEntity(currentPos);
                    if (!(blockEntity instanceof LinkTranslatorBlockEntity) || !(translator = (LinkTranslatorBlockEntity)blockEntity).hasBook()) continue;
                    LinkData linkData = (LinkData)translator.getBook().get(ModDataComponents.LINK_DATA);
                    LinkingPortalArea.tryMakeLinkingPortalOnEveryAxis(world, currentPos, linkData, translator);
                }
            }
        }
    }

    @Nonnull
    public InteractionResult useWithoutItem(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull BlockHitResult hit) {
        BlockEntity generic = world.getBlockEntity(pos);
        if (generic instanceof LinkTranslatorBlockEntity) {
            ItemStack stack;
            Item item;
            LinkTranslatorBlockEntity blockEntity = (LinkTranslatorBlockEntity)generic;
            if (!world.isClientSide() && blockEntity.hasBook() && !player.isShiftKeyDown() && ((item = (stack = blockEntity.getBook()).getItem()) instanceof WrittenLinkingBookItem || item instanceof ReltoBookItem)) {
                Tag ownerTag;
                CustomData customData;
                LinkData linkData = (LinkData)stack.get(ModDataComponents.LINK_DATA);
                if (linkData != null) {
                    LinkingUtils.openLinkingBookGui((ServerPlayer)player, false, LinkingUtils.getLinkingBookColor(stack, 0), linkData, world.dimension().location());
                } else if (stack.getItem() instanceof ReltoBookItem && (customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA)) != null && (ownerTag = customData.copyTag().get("owner")) != null && ownerTag.getType() == TagTypes.getType((int)11)) {
                    LinkingUtils.openReltoBookGui((ServerPlayer)player, customData.copyTag().getUUID("owner"));
                }
            }
        }
        return InteractionResult.PASS;
    }

    public boolean useShapeForLightOcclusion(@Nonnull BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockGetter blockGetter, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void onRemove(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        ItemStack stack;
        LinkTranslatorBlockEntity translatorTE;
        BlockEntity tileEntity;
        if (state.getBlock() != newState.getBlock() && !world.isClientSide() && (tileEntity = world.getBlockEntity(pos)) instanceof LinkTranslatorBlockEntity && (translatorTE = (LinkTranslatorBlockEntity)tileEntity).hasBook() && ((stack = translatorTE.getBook()).getItem() instanceof WrittenLinkingBookItem || stack.getItem() instanceof ReltoBookItem)) {
            LinkingBookEntity entity = new LinkingBookEntity(world, stack.copy());
            entity.absMoveTo((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, ((Direction)state.getValue((Property)FACING)).toYRot() + 180.0f, 0.0f);
            world.addFreshEntity((Entity)entity);
        }
        for (int x = pos.getX() - 32; x < pos.getX() + 32; ++x) {
            for (int y = pos.getY() - 32; y < pos.getY() + 32; ++y) {
                for (int z = pos.getZ() - 32; z < pos.getZ() + 32; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    BlockEntity blockEntity = world.getBlockEntity(currentPos);
                    if (!(blockEntity instanceof LinkTranslatorBlockEntity)) continue;
                    LinkTranslatorBlockEntity translator = (LinkTranslatorBlockEntity)blockEntity;
                    if (Reference.isImmersivePortalsLoaded()) {
                        ImmersivePortalsIntegration.deleteLinkingPortals(translator);
                    }
                    if (!translator.hasBook()) continue;
                    LinkData linkData = (LinkData)translator.getBook().get(ModDataComponents.LINK_DATA);
                    LinkingPortalArea.tryMakeLinkingPortalOnEveryAxis(world, currentPos, linkData, translator);
                }
            }
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> EAST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }
}

