/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.block;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.blockentity.LinkTranslatorBlockEntity;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.component.ModDataComponents;
import thefloydman.linkingbooks.integration.ImmersivePortalsIntegration;
import thefloydman.linkingbooks.linking.LinkingPortalArea;

public class NaraBlock
extends Block {
    public NaraBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void setPlacedBy(@Nonnull Level world, @Nonnull BlockPos blockPos, @Nonnull BlockState blockState, LivingEntity livingEntity, @Nonnull ItemStack itemStack) {
        super.setPlacedBy(world, blockPos, blockState, livingEntity, itemStack);
        for (int x = blockPos.getX() - 32; x < blockPos.getX() + 32; ++x) {
            for (int y = blockPos.getY() - 32; y < blockPos.getY() + 32; ++y) {
                for (int z = blockPos.getZ() - 32; z < blockPos.getZ() + 32; ++z) {
                    LinkTranslatorBlockEntity translator;
                    BlockPos currentPos = new BlockPos(x, y, z);
                    BlockEntity blockEntity = world.getBlockEntity(currentPos);
                    if (!(blockEntity instanceof LinkTranslatorBlockEntity) || !(translator = (LinkTranslatorBlockEntity)blockEntity).hasBook()) continue;
                    LinkData linkData = (LinkData)translator.getBook().get(ModDataComponents.LINK_DATA);
                    LinkingPortalArea.tryMakeLinkingPortalOnEveryAxis(world, currentPos, linkData, translator);
                }
            }
        }
    }

    public void onRemove(BlockState blockState, @Nonnull Level world, @Nonnull BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.is(blockState2.getBlock())) {
            for (int x = blockPos.getX() - 32; x < blockPos.getX() + 32; ++x) {
                for (int y = blockPos.getY() - 32; y < blockPos.getY() + 32; ++y) {
                    for (int z = blockPos.getZ() - 32; z < blockPos.getZ() + 32; ++z) {
                        BlockPos currentPos = new BlockPos(x, y, z);
                        BlockEntity blockEntity = world.getBlockEntity(currentPos);
                        if (!(blockEntity instanceof LinkTranslatorBlockEntity)) continue;
                        LinkTranslatorBlockEntity translator = (LinkTranslatorBlockEntity)blockEntity;
                        if (Reference.isImmersivePortalsLoaded()) {
                            ImmersivePortalsIntegration.deleteLinkingPortals(translator);
                        }
                        if (!translator.hasBook()) continue;
                        LinkData linkData = (LinkData)translator.getBook().get(ModDataComponents.LINK_DATA);
                        LinkingPortalArea.tryMakeLinkingPortalOnEveryAxis(world, currentPos, linkData, translator);
                    }
                }
            }
        }
        super.onRemove(blockState, world, blockPos, blockState2, bl);
    }
}

