/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.gui.book;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.client.gui.book.GuiBookImage;
import thefloydman.linkingbooks.client.gui.book.GuiBookParagraph;
import thefloydman.linkingbooks.client.gui.book.GuiBookRecipe;
import thefloydman.linkingbooks.client.gui.book.GuiBookRecipeCarousel;

@OnlyIn(value=Dist.CLIENT)
public class GuiBookManager
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_RESET = "\u00a7r";
    private static final Map<String, String> FORMAT_MAP = Maps.newHashMap();
    private static final Map<String, String> COLOR_MAP = Maps.newHashMap();
    private static Map<Integer, List<Object>> guidebookPages = Maps.newHashMap();

    public static Map<Integer, List<Object>> getPages() {
        return guidebookPages;
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        guidebookPages = Maps.newHashMap();
        String currentLang = Minecraft.getInstance().getLanguageManager().getSelected();
        Set guidebookResources = resourceManager.listResources("lang/linkingbooks/guidebook", resourceLocation -> resourceLocation.getPath().endsWith(String.format("%s.xml", currentLang))).keySet();
        for (ResourceLocation resourceLocation2 : guidebookResources) {
            Document document = null;
            try {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Optional optionalResource = resourceManager.getResource(Reference.getAsResourceLocation("lang/linkingbooks/guidebook/schema.xsd"));
                if (optionalResource.isEmpty()) continue;
                Schema schema = factory.newSchema(new StreamSource(((Resource)optionalResource.get()).open()));
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setSchema(schema);
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                document = builder.parse(resourceManager.open(resourceLocation2));
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                LOGGER.error(e.getMessage());
            }
            if (document == null) continue;
            NodeList pageNodes = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < pageNodes.getLength(); ++i) {
                Node pageNode = pageNodes.item(i);
                if (pageNode.getNodeType() != 1 || !pageNode.getNodeName().equals("page")) continue;
                ArrayList elementList = Lists.newArrayList();
                NodeList elementNodes = pageNode.getChildNodes();
                block16: for (int j = 0; j < elementNodes.getLength(); ++j) {
                    Node elementNode = elementNodes.item(j);
                    if (elementNode.getNodeType() != 1) continue;
                    switch (elementNode.getNodeName()) {
                        case "p": {
                            NodeList paragraphChildNodes = elementNode.getChildNodes();
                            for (int k = 0; k < paragraphChildNodes.getLength(); ++k) {
                                Node paragraphChildNode = paragraphChildNodes.item(k);
                                if (paragraphChildNode.getNodeName().equals("style")) {
                                    Object colorCode = "";
                                    StringBuilder formatCode = new StringBuilder();
                                    if (!paragraphChildNode.hasAttributes()) continue;
                                    NamedNodeMap styleNodeMap = paragraphChildNode.getAttributes();
                                    for (int l = 0; l < styleNodeMap.getLength(); ++l) {
                                        Node attribute = styleNodeMap.item(l);
                                        if (attribute.getNodeValue() == null) continue;
                                        if (attribute.getNodeName().equals("color")) {
                                            String color = COLOR_MAP.get(attribute.getNodeValue());
                                            colorCode = color == null ? "" : "\u00a7" + color;
                                            continue;
                                        }
                                        if (!attribute.getNodeValue().equals("true")) continue;
                                        String format = FORMAT_MAP.get(attribute.getNodeName());
                                        formatCode.append((String)(format == null ? "" : "\u00a7" + format));
                                    }
                                    paragraphChildNode.setTextContent((String)colorCode + String.valueOf(formatCode) + paragraphChildNode.getTextContent() + TAG_RESET);
                                    continue;
                                }
                                if (!paragraphChildNode.getNodeName().equals("br")) continue;
                                paragraphChildNode.setTextContent("/u000a");
                            }
                            List<String> brokenLines = Stream.of(elementNode.getTextContent().split("/u000a")).toList();
                            GuiBookParagraph paragraph = new GuiBookParagraph(brokenLines);
                            elementList.add(paragraph);
                            continue block16;
                        }
                        case "img": {
                            NamedNodeMap imageNodeMap = elementNode.getAttributes();
                            ResourceLocation location = ResourceLocation.parse((String)imageNodeMap.getNamedItem("src").getNodeValue());
                            float scale = imageNodeMap.getNamedItem("scale") == null ? 1.0f : Float.parseFloat(imageNodeMap.getNamedItem("scale").getNodeValue());
                            int width = imageNodeMap.getNamedItem("width") == null ? 256 : Integer.parseInt(imageNodeMap.getNamedItem("width").getNodeValue());
                            int height = imageNodeMap.getNamedItem("height") == null ? 256 : Integer.parseInt(imageNodeMap.getNamedItem("height").getNodeValue());
                            elementList.add(new GuiBookImage(location, scale, width, height));
                            continue block16;
                        }
                        case "recipe": {
                            if (!elementNode.hasAttributes()) continue block16;
                            NamedNodeMap attributes = elementNode.getAttributes();
                            String source = attributes.getNamedItem("src") == null ? "" : attributes.getNamedItem("src").getNodeValue();
                            elementList.add(new GuiBookRecipe(RecipeType.CRAFTING, ResourceLocation.tryParse((String)source)));
                            continue block16;
                        }
                        case "recipes": {
                            if (!elementNode.hasChildNodes()) continue block16;
                            NodeList recipeNodeList = elementNode.getChildNodes();
                            ArrayList recipeLocationList = Lists.newArrayList();
                            for (int k = 0; k < recipeNodeList.getLength(); ++k) {
                                Node recipeNode = recipeNodeList.item(k);
                                if (recipeNode.getNodeType() != 1 || !recipeNode.getNodeName().equals("rec") || !recipeNode.hasAttributes()) continue;
                                NamedNodeMap attributes = recipeNode.getAttributes();
                                String source = attributes.getNamedItem("src") == null ? "" : attributes.getNamedItem("src").getNodeValue();
                                recipeLocationList.add(ResourceLocation.tryParse((String)source));
                            }
                            elementList.add(new GuiBookRecipeCarousel(RecipeType.CRAFTING, recipeLocationList));
                        }
                    }
                }
                guidebookPages.put(guidebookPages.size(), elementList);
            }
        }
        LOGGER.info("Successfully imported {} guidebook pages for Linking Books.", (Object)guidebookPages.size());
    }

    static {
        COLOR_MAP.put("black", "0");
        COLOR_MAP.put("dark_blue", "1");
        COLOR_MAP.put("dark_green", "2");
        COLOR_MAP.put("dark_aqua", "3");
        COLOR_MAP.put("dark_red", "4");
        COLOR_MAP.put("dark_purple", "5");
        COLOR_MAP.put("gold", "6");
        COLOR_MAP.put("gray", "7");
        COLOR_MAP.put("dark_gray", "8");
        COLOR_MAP.put("blue", "9");
        COLOR_MAP.put("green", "a");
        COLOR_MAP.put("aqua", "b");
        COLOR_MAP.put("red", "c");
        COLOR_MAP.put("light_purple", "d");
        COLOR_MAP.put("yellow", "e");
        COLOR_MAP.put("white", "f");
        FORMAT_MAP.put("obfuscated", "k");
        FORMAT_MAP.put("bold", "l");
        FORMAT_MAP.put("strikethrough", "m");
        FORMAT_MAP.put("underline", "n");
        FORMAT_MAP.put("italic", "o");
    }
}

