/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.gui.book;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.compress.utils.Lists;
import thefloydman.linkingbooks.client.gui.book.GuiBookElement;
import thefloydman.linkingbooks.client.gui.widget.ParagraphWidget;

@OnlyIn(value=Dist.CLIENT)
public class GuiBookParagraph
extends GuiBookElement<ParagraphWidget> {
    private final int lineSpacing = 6;
    private final List<String> contents;

    public GuiBookParagraph(List<String> contents) {
        super("paragraph");
        this.contents = contents;
    }

    @Override
    public ParagraphWidget getAsWidget(String id, int x, int y, float z, int width, int height, Screen parentScreen, float scale, Font font) {
        ArrayList outputParagraph = Lists.newArrayList();
        for (String span : this.contents) {
            List wordList = Stream.of(span.split(" ")).collect(Collectors.toList());
            boolean excessWords = true;
            boolean styled = false;
            StringBuilder style = new StringBuilder();
            String lastStyle = "";
            while (excessWords) {
                int index;
                ArrayList lineList = Lists.newArrayList();
                excessWords = false;
                Object postWord = "";
                String currentLine = "";
                for (index = 0; index < wordList.size(); ++index) {
                    String preWord;
                    String temp = preWord = (String)wordList.get(index);
                    while (temp.contains("\u00a7")) {
                        int currentIndex = temp.indexOf("\u00a7");
                        String sub = temp.substring(currentIndex, currentIndex + 2);
                        boolean bl = styled = !sub.equals("\u00a7r");
                        if (styled) {
                            style.append(sub);
                        } else {
                            lastStyle = style.toString();
                            style = new StringBuilder();
                        }
                        temp = currentIndex + 2 < temp.length() ? temp.substring(currentIndex + 2) : "";
                    }
                    postWord = (index == 0 && styled ? style.toString() : "") + preWord;
                    lineList.add(postWord);
                    currentLine = String.join((CharSequence)" ", lineList);
                    boolean bl = excessWords = (float)font.width(currentLine) > (float)width / scale && lineList.size() > 1;
                    if (!excessWords) continue;
                    if (preWord.contains("\u00a7r")) {
                        postWord = lastStyle + preWord;
                    }
                    wordList.set(index, postWord);
                    lineList.removeLast();
                    break;
                }
                outputParagraph.add(Component.literal((String)String.join((CharSequence)" ", lineList)));
                if (!excessWords) continue;
                wordList = wordList.subList(index, wordList.size());
            }
        }
        return new ParagraphWidget(id, x, y, z, width, (int)((float)(outputParagraph.size() * this.lineSpacing) / scale), (Component)Component.literal((String)"Paragraph"), parentScreen, scale, outputParagraph, this.lineSpacing, font);
    }
}

