/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.gui.book;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.compress.utils.Lists;
import thefloydman.linkingbooks.client.gui.book.GuiBookElement;
import thefloydman.linkingbooks.client.gui.widget.RecipeCarouselWidget;

@OnlyIn(value=Dist.CLIENT)
public class GuiBookRecipeCarousel
extends GuiBookElement<RecipeCarouselWidget> {
    private final List<ResourceLocation> resourceLocations;
    private final RecipeType<?> recipeType;

    public GuiBookRecipeCarousel(RecipeType<?> recipeType, List<ResourceLocation> resourceLocations) {
        super("recipecarousel");
        this.resourceLocations = resourceLocations;
        this.recipeType = recipeType;
    }

    @Override
    public RecipeCarouselWidget getAsWidget(String id, int x, int y, float z, int width, int height, Screen parentScreen, float scale, Font font) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return null;
        }
        RecipeManager recipeManager = level.getRecipeManager();
        int gridWidth = 107;
        int gridHeight = 62;
        ArrayList recipesList = Lists.newArrayList();
        for (ResourceLocation location : this.resourceLocations) {
            ArrayList singleList = Lists.newArrayList();
            RecipeHolder recipeHolder = recipeManager.byKey(location).orElse(null);
            Recipe recipe = null;
            if (recipeHolder != null) {
                recipe = recipeHolder.value();
            }
            if (recipe == null || recipe.getType() != this.recipeType) continue;
            if (this.recipeType == RecipeType.CRAFTING) {
                NonNullList ingredients = recipe.getIngredients();
                for (Ingredient ingredient : ingredients) {
                    singleList.add(Stream.of(ingredient.getItems()).toList());
                }
            }
            singleList.add(Stream.of(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())).toList());
            recipesList.add(singleList);
        }
        return new RecipeCarouselWidget(id, (int)((float)x + ((float)width - (float)gridWidth * scale) / 2.0f), y, z, gridWidth, gridHeight, (Component)Component.literal((String)"Recipe"), parentScreen, scale, recipesList);
    }
}

