/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.gui.widget;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import thefloydman.linkingbooks.client.gui.widget.NestedWidget;

@OnlyIn(value=Dist.CLIENT)
public class ParagraphWidget
extends NestedWidget {
    public List<Component> lines;
    public int lineSpacing;
    public Font font;

    public ParagraphWidget(String id, int x, int y, float z, int width, int height, Component narration, Screen parentScreen, float scale, List<Component> lines, int lineSpacing, Font font) {
        super(id, x, y, z, width, height, narration, parentScreen, scale);
        this.lines = lines;
        this.lineSpacing = lineSpacing;
        this.font = font;
    }

    @Override
    public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.getVisible()) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(this.scale, this.scale, 1.0f);
            float currentY = this.getY();
            for (int k = 0; k < this.lines.size(); ++k) {
                currentY = this.getY() + this.lineSpacing * k;
                guiGraphics.drawString(this.font, this.lines.get(k).getVisualOrderText(), (float)this.getX() / this.scale, currentY / this.scale, 0, false);
            }
            guiGraphics.pose().popPose();
        }
    }
}

