/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.client.gui.widget.LinkingPanelWidget;
import thefloydman.linkingbooks.client.gui.widget.NestedWidget;
import thefloydman.linkingbooks.component.LinkData;

@OnlyIn(value=Dist.CLIENT)
public class ReltoBookWidget
extends NestedWidget {
    private static final ResourceLocation COVER_TEXTURE = Reference.getAsResourceLocation("textures/gui/book/book_cover_narrow.png");
    private static final ResourceLocation PAPER_TEXTURE = Reference.getAsResourceLocation("textures/gui/book/book_paper_narrow.png");
    private final Component ageName;
    public int color = new Color(77, 196, 109).getRGB();

    public ReltoBookWidget(String id, int x, int y, float z, int width, int height, Component narration, Screen parentScreen, float scale, LinkData linkData, Component ageName) {
        super(id, x, y, z, width, height, narration, parentScreen, scale);
        this.ageName = ageName;
        LinkingPanelWidget linkingPanel = this.addChild(new LinkingPanelWidget("linking panel", this.getX() + 107, this.getY() + 41, z + 1.0f, 64, 42, (Component)Component.literal((String)"Linking Panel"), parentScreen, this.scale, false, true, linkData, true, null));
        for (GuiEventListener listener : this.listeners) {
            linkingPanel.addListener(listener);
        }
    }

    @Override
    public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.getVisible()) {
            guiGraphics.pose().pushPose();
            float[] color = new Color(this.color).getRGBColorComponents(null);
            RenderSystem.setShaderColor((float)Mth.clamp((float)color[0], (float)0.1f, (float)1.0f), (float)Mth.clamp((float)color[1], (float)0.1f, (float)1.0f), (float)Mth.clamp((float)color[2], (float)0.1f, (float)1.0f), (float)1.0f);
            guiGraphics.blit(COVER_TEXTURE, this.getX(), this.getY(), 0, 0, this.width, this.height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.blit(PAPER_TEXTURE, this.getX(), this.getY(), 0, 0, this.width, this.height);
            this.renderChildren(guiGraphics, mouseX, mouseY, partialTicks);
            guiGraphics.pose().popPose();
            guiGraphics.pose().pushPose();
            float fontScale = 0.5f;
            guiGraphics.pose().scale(fontScale, fontScale, 1.0f);
            float textWidth = this.minecraft.font.width(this.ageName.getVisualOrderText());
            float textX = ((float)this.getX() / this.scale + 139.0f) / fontScale - textWidth / 2.0f;
            float textY = ((float)this.getY() / this.scale + 12.0f) / fontScale;
            guiGraphics.drawString(this.minecraft.font, this.ageName.getVisualOrderText(), textX, textY, 0, false);
            guiGraphics.pose().popPose();
        }
    }
}

