/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.renderer.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import thefloydman.linkingbooks.entity.LinkingBookEntity;

public class LinkingBookCoverModel
extends EntityModel<LinkingBookEntity> {
    private final ModelPart coverRight;
    private final ModelPart coverLeft;
    private final ModelPart bookSpine;
    private final List<ModelPart> allModels;

    public LinkingBookCoverModel(ModelPart model) {
        super(RenderType::entitySolid);
        this.coverRight = model.getChild("right_cover");
        this.coverLeft = model.getChild("left_cover");
        this.bookSpine = model.getChild("spine");
        this.allModels = Arrays.asList(this.coverRight, this.coverLeft, this.bookSpine);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("right_cover", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -5.0f, -0.005f, 6.0f, 10.0f, 0.005f), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("left_cover", CubeListBuilder.create().texOffs(16, 0).addBox(0.0f, -5.0f, -0.005f, 6.0f, 10.0f, 0.005f), PartPose.offset((float)0.0f, (float)0.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("spine", CubeListBuilder.create().texOffs(12, 0).addBox(-1.0f, -5.0f, 0.0f, 2.0f, 10.0f, 0.005f), PartPose.rotation((float)0.0f, (float)1.5707964f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void renderToBuffer(@Nonnull PoseStack matrixStackIn, @Nonnull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.allModels.forEach(model -> model.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color));
    }

    public void setBookState(float openAmount) {
        float radians = Mth.clamp((float)(1.5707964f * openAmount), (float)0.0f, (float)1.5707964f);
        this.coverRight.yRot = (float)Math.PI + radians;
        this.coverLeft.yRot = -radians;
    }

    public void setupAnim(LinkingBookEntity arg0, float arg1, float arg2, float arg3, float arg4, float arg5) {
    }
}

