/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.renderer.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import thefloydman.linkingbooks.entity.LinkingBookEntity;

public class LinkingBookPagesModel
extends EntityModel<LinkingBookEntity> {
    private final ModelPart pagesRight;
    private final ModelPart pagesLeft;
    private final List<ModelPart> allModels;

    public LinkingBookPagesModel(ModelPart model) {
        super(RenderType::entitySolid);
        this.pagesRight = model.getChild("right_pages");
        this.pagesLeft = model.getChild("left_pages");
        this.allModels = Arrays.asList(this.pagesRight, this.pagesLeft);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("right_pages", CubeListBuilder.create().texOffs(0, 10).addBox(0.0f, -4.0f, -0.99f, 5.0f, 8.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_pages", CubeListBuilder.create().texOffs(12, 10).addBox(0.0f, -4.0f, -0.01f, 5.0f, 8.0f, 1.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.allModels.forEach(model -> model.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color));
    }

    public void setBookState(float openAmount) {
        float radians;
        this.pagesRight.yRot = radians = Mth.clamp((float)(1.5707964f * openAmount), (float)0.0f, (float)1.5707964f);
        this.pagesLeft.yRot = -radians;
        this.pagesRight.x = Mth.sin((float)radians);
        this.pagesLeft.x = Mth.sin((float)radians);
    }

    public void setupAnim(LinkingBookEntity arg0, float arg1, float arg2, float arg3, float arg4, float arg5) {
    }
}

