/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.linking.LinkingUtils;

public class LinkCommand {
    private static final String ENTITIES = "teleporting_entities";
    private static final String ENTITY = "destination_entity";
    private static final String POSITION = "position";
    private static final String DIMENSION = "dimension";

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"link").requires(context -> context.hasPermission(2))).then(Commands.argument((String)ENTITIES, (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)POSITION, (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            ResourceLocation dimension = ((CommandSourceStack)context.getSource()).getPlayerOrException().getCommandSenderWorld().dimension().location();
            BlockPos blockPos = BlockPosArgument.getSpawnablePos((CommandContext)context, (String)POSITION);
            float rotation = ((CommandSourceStack)context.getSource()).getPlayerOrException().getYRot();
            List<ResourceLocation> linkEffects = List.of(Reference.getAsResourceLocation("intraage_linking"));
            LinkData linkData = new LinkData(dimension, blockPos, rotation, UUID.randomUUID(), linkEffects);
            return LinkingUtils.linkEntities(new ArrayList<Entity>(EntityArgument.getEntities((CommandContext)context, (String)ENTITIES)), linkData, false);
        })))).then(Commands.argument((String)ENTITIES, (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)DIMENSION, (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)POSITION, (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            ResourceLocation dimension = DimensionArgument.getDimension((CommandContext)context, (String)DIMENSION).dimension().location();
            BlockPos blockPos = BlockPosArgument.getSpawnablePos((CommandContext)context, (String)POSITION);
            float rotation = ((CommandSourceStack)context.getSource()).getPlayerOrException().getYRot();
            List<ResourceLocation> linkEffects = List.of(Reference.getAsResourceLocation("intraage_linking"));
            LinkData linkData = new LinkData(dimension, blockPos, rotation, UUID.randomUUID(), linkEffects);
            return LinkingUtils.linkEntities(new ArrayList<Entity>(EntityArgument.getEntities((CommandContext)context, (String)ENTITIES)), linkData, false);
        }))))).then(Commands.argument((String)DIMENSION, (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)POSITION, (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            ResourceLocation dimension = DimensionArgument.getDimension((CommandContext)context, (String)DIMENSION).dimension().location();
            BlockPos blockPos = BlockPosArgument.getSpawnablePos((CommandContext)context, (String)POSITION);
            float rotation = ((CommandSourceStack)context.getSource()).getPlayerOrException().getYRot();
            List<ResourceLocation> linkEffects = List.of(Reference.getAsResourceLocation("intraage_linking"));
            LinkData linkData = new LinkData(dimension, blockPos, rotation, UUID.randomUUID(), linkEffects);
            return LinkingUtils.linkEntities(new ArrayList<Entity>(Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).getPlayerOrException()})), linkData, false);
        })))).then(Commands.argument((String)POSITION, (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            ResourceLocation dimension = ((CommandSourceStack)context.getSource()).getPlayerOrException().getCommandSenderWorld().dimension().location();
            BlockPos blockPos = BlockPosArgument.getSpawnablePos((CommandContext)context, (String)POSITION);
            float rotation = ((CommandSourceStack)context.getSource()).getPlayerOrException().getYRot();
            List<ResourceLocation> linkEffects = List.of(Reference.getAsResourceLocation("intraage_linking"));
            LinkData linkData = new LinkData(dimension, blockPos, rotation, UUID.randomUUID(), linkEffects);
            return LinkingUtils.linkEntities(new ArrayList<Entity>(Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).getPlayerOrException()})), linkData, false);
        }))).then(Commands.argument((String)ENTITIES, (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)ENTITY, (ArgumentType)EntityArgument.entity()).executes(context -> {
            ResourceLocation dimension = EntityArgument.getEntity((CommandContext)context, (String)ENTITY).getCommandSenderWorld().dimension().location();
            BlockPos blockPos = EntityArgument.getEntity((CommandContext)context, (String)ENTITY).blockPosition();
            List<ResourceLocation> linkEffects = List.of(Reference.getAsResourceLocation("intraage_linking"));
            int i = 0;
            for (Entity entity : EntityArgument.getEntities((CommandContext)context, (String)ENTITIES)) {
                float rotation = entity.getYRot();
                LinkData linkData = new LinkData(dimension, blockPos, rotation, UUID.randomUUID(), linkEffects);
                i += LinkingUtils.linkEntities(new ArrayList<Entity>(Lists.newArrayList((Object[])new Entity[]{entity})), linkData, false);
            }
            return i;
        }))));
    }
}

