/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import thefloydman.linkingbooks.linking.LinkingUtils;

public class ReltoCommand {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"relto").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).executes(commandContext -> {
            if (!((CommandSourceStack)commandContext.getSource()).isPlayer()) {
                LOGGER.info("Only players can use the /relto command.");
                return 0;
            }
            ServerPlayer player = ((CommandSourceStack)commandContext.getSource()).getPlayer();
            return player == null ? 0 : LinkingUtils.linkToRelto(player, player.getUUID());
        }));
    }
}

