/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.entity;

import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.component.ModDataComponents;
import thefloydman.linkingbooks.entity.ModEntityTypes;
import thefloydman.linkingbooks.entity.ObjectEntity;
import thefloydman.linkingbooks.item.ReltoBookItem;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;
import thefloydman.linkingbooks.linking.LinkingUtils;

public class LinkingBookEntity
extends ObjectEntity {
    protected LinkingBookEntity(EntityType<? extends LinkingBookEntity> type, Level world) {
        super(type, world, WrittenLinkingBookItem.class, 10.0f);
        if (world.isClientSide()) {
            LinkingBookEntity.setViewScale((double)2.0);
        }
    }

    protected LinkingBookEntity(EntityType<? extends LinkingBookEntity> type, Level world, ItemStack item) {
        super(type, world, WrittenLinkingBookItem.class, 10.0f, item);
        if (world.isClientSide()) {
            LinkingBookEntity.setViewScale((double)2.0);
        }
    }

    public LinkingBookEntity(Level world) {
        this(ModEntityTypes.LINKING_BOOK.get(), world);
    }

    public LinkingBookEntity(Level world, ItemStack item) {
        this(ModEntityTypes.LINKING_BOOK.get(), world, item);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!player.getCommandSenderWorld().isClientSide()) {
            ItemStack bookStack;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (hand == InteractionHand.MAIN_HAND && !(bookStack = this.getItem()).isEmpty()) {
                Tag ownerTag;
                CustomData customData;
                if (serverPlayer.isShiftKeyDown()) {
                    serverPlayer.addItem(bookStack);
                    serverPlayer.inventoryMenu.broadcastChanges();
                    this.remove(Entity.RemovalReason.DISCARDED);
                    return InteractionResult.SUCCESS;
                }
                LinkData linkData = (LinkData)bookStack.get(ModDataComponents.LINK_DATA);
                if (linkData != null) {
                    LinkingUtils.openLinkingBookGui(serverPlayer, false, LinkingUtils.getLinkingBookColor(bookStack, 0), linkData, serverPlayer.getCommandSenderWorld().dimension().location());
                    return InteractionResult.CONSUME;
                }
                if (bookStack.getItem() instanceof ReltoBookItem && (customData = (CustomData)bookStack.get(DataComponents.CUSTOM_DATA)) != null && (ownerTag = customData.copyTag().get("owner")) != null && ownerTag.getType() == TagTypes.getType((int)11)) {
                    LinkingUtils.openReltoBookGui(serverPlayer, customData.copyTag().getUUID("owner"));
                }
            }
        }
        return InteractionResult.PASS;
    }
}

