/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.event;

import com.mojang.brigadier.CommandDispatcher;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.PacketDistributor;
import thefloydman.linkingbooks.LinkingBooksConfig;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.block.LinkTranslatorBlock;
import thefloydman.linkingbooks.block.LinkingLecternBlock;
import thefloydman.linkingbooks.block.MarkerSwitchBlock;
import thefloydman.linkingbooks.block.ModBlocks;
import thefloydman.linkingbooks.blockentity.LinkTranslatorBlockEntity;
import thefloydman.linkingbooks.blockentity.LinkingBookHolderBlockEntity;
import thefloydman.linkingbooks.blockentity.LinkingLecternBlockEntity;
import thefloydman.linkingbooks.blockentity.MarkerSwitchBlockEntity;
import thefloydman.linkingbooks.blockentity.ModBlockEntityTypes;
import thefloydman.linkingbooks.commands.LinkCommand;
import thefloydman.linkingbooks.commands.ReltoCommand;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.component.ModDataComponents;
import thefloydman.linkingbooks.entity.LinkingBookEntity;
import thefloydman.linkingbooks.event.ClientLevelGetSkyDarkenEvent;
import thefloydman.linkingbooks.event.LevelUpdateSkyBrightnessEvent;
import thefloydman.linkingbooks.integration.ImmersivePortalsIntegration;
import thefloydman.linkingbooks.item.ModItems;
import thefloydman.linkingbooks.item.ReltoBookItem;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;
import thefloydman.linkingbooks.linking.LinkingPortalArea;
import thefloydman.linkingbooks.linking.LinkingUtils;
import thefloydman.linkingbooks.network.client.UpdateClientAgeInfoMapMessage;
import thefloydman.linkingbooks.network.client.UpdatePlayerDisplayNamesMessage;
import thefloydman.linkingbooks.world.generation.AgeInfo;
import thefloydman.linkingbooks.world.generation.AgeUtils;
import thefloydman.linkingbooks.world.sky.HorizonInfo;
import thefloydman.linkingbooks.world.sky.SkyUtils;
import thefloydman.linkingbooks.world.storage.LinkingBooksSavedData;

@EventBusSubscriber(modid="linkingbooks", bus=EventBusSubscriber.Bus.GAME)
public class GameEventHandler {
    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server;
        Reference.server = server = event.getServer();
        AgeUtils.updateAgeInfosOnStartup(server);
        AgeUtils.mapLevelsOnStartup(server);
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        LinkCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ReltoCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void tossItem(ItemTossEvent event) {
        ItemStack stack = event.getEntity().getItem();
        if (stack.getItem() instanceof WrittenLinkingBookItem || stack.getItem() instanceof ReltoBookItem) {
            event.setCanceled(true);
            Player player = event.getPlayer();
            Level world = event.getEntity().getCommandSenderWorld();
            LinkingBookEntity entity = new LinkingBookEntity(world, stack.copy());
            Vec3 lookVec = player.getLookAngle();
            entity.setPos(player.getX() + lookVec.x(), player.getY() + 1.75 + lookVec.y(), player.getZ() + lookVec.z());
            entity.setYRot(player.yHeadRot);
            entity.push(lookVec.x / 4.0, lookVec.y / 4.0, lookVec.z / 4.0);
            world.addFreshEntity((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity genericOriginalBlockEntity;
        BlockState blockState;
        Level level = event.getLevel();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (level.isClientSide() || hand.equals((Object)InteractionHand.OFF_HAND) || !player.isShiftKeyDown()) {
            return;
        }
        BlockPos blockPos = event.getPos();
        Block block = level.getBlockState(blockPos).getBlock();
        if (block instanceof LinkingLecternBlock || block instanceof LinkTranslatorBlock) {
            BlockEntity generic = level.getBlockEntity(blockPos);
            if (!(generic instanceof LinkingBookHolderBlockEntity)) {
                return;
            }
            LinkingBookHolderBlockEntity linkingBookHolderBlockEntity = (LinkingBookHolderBlockEntity)generic;
            ItemStack itemStack = player.getItemInHand(hand);
            if ((itemStack.getItem() instanceof WrittenLinkingBookItem || itemStack.getItem() instanceof ReltoBookItem) && !linkingBookHolderBlockEntity.hasBook()) {
                ItemStack returnedItemStack = linkingBookHolderBlockEntity.insertItem(0, itemStack, false);
                player.getInventory().setItem(player.getInventory().findSlotMatchingItem(itemStack), returnedItemStack);
                player.inventoryMenu.broadcastChanges();
                if (level.getBlockEntity(blockPos) instanceof LinkTranslatorBlockEntity) {
                    LinkTranslatorBlockEntity linkTranslatorTileEntity = (LinkTranslatorBlockEntity)linkingBookHolderBlockEntity;
                    LinkData linkData = (LinkData)itemStack.getOrDefault(ModDataComponents.LINK_DATA, (Object)LinkData.EMPTY);
                    LinkingPortalArea.tryMakeLinkingPortalOnEveryAxis(level, blockPos, linkData, linkTranslatorTileEntity);
                }
            } else if (itemStack.isEmpty() && linkingBookHolderBlockEntity.hasBook()) {
                ItemStack extractedStack = linkingBookHolderBlockEntity.extractItem(0, Integer.MAX_VALUE, false);
                player.addItem(extractedStack);
                player.inventoryMenu.broadcastChanges();
                BlockEntity linkData = level.getBlockEntity(blockPos);
                if (linkData instanceof LinkTranslatorBlockEntity) {
                    LinkTranslatorBlockEntity linkTranslatorBlockEntity = (LinkTranslatorBlockEntity)linkData;
                    if (Reference.isImmersivePortalsLoaded()) {
                        ImmersivePortalsIntegration.deleteLinkingPortals(linkTranslatorBlockEntity);
                    }
                    LinkingPortalArea.tryEraseLinkingPortalOnEveryAxis(level, blockPos);
                }
            }
        } else if (block instanceof MarkerSwitchBlock && ((Boolean)(blockState = level.getBlockState(blockPos)).getValue((Property)MarkerSwitchBlock.OPEN)).booleanValue() && (genericOriginalBlockEntity = level.getBlockEntity(blockPos)) instanceof MarkerSwitchBlockEntity) {
            MarkerSwitchBlockEntity originalBlockEntity = (MarkerSwitchBlockEntity)genericOriginalBlockEntity;
            BlockEntity genericTwinBlockEntity = blockState.getValue(MarkerSwitchBlock.HALF) == DoubleBlockHalf.LOWER ? level.getBlockEntity(blockPos.above()) : level.getBlockEntity(blockPos.below());
            ItemStack itemStack = player.getItemInHand(hand);
            if (!originalBlockEntity.hasItem()) {
                if (!itemStack.isEmpty()) {
                    ItemStack returnedItemStack = originalBlockEntity.insertItem(0, itemStack, false);
                    if (genericTwinBlockEntity instanceof MarkerSwitchBlockEntity) {
                        MarkerSwitchBlockEntity twinBlockEntity = (MarkerSwitchBlockEntity)genericTwinBlockEntity;
                        twinBlockEntity.insertItem(0, itemStack, false);
                    }
                    player.getInventory().setItem(player.getInventory().selected, returnedItemStack);
                    player.inventoryMenu.broadcastChanges();
                }
            } else {
                ItemStack extractedStack = originalBlockEntity.extractItem(0, Integer.MAX_VALUE, false);
                player.addItem(extractedStack);
                player.inventoryMenu.broadcastChanges();
                if (genericTwinBlockEntity instanceof MarkerSwitchBlockEntity) {
                    MarkerSwitchBlockEntity twinBlockEntity = (MarkerSwitchBlockEntity)genericTwinBlockEntity;
                    twinBlockEntity.extractItem(0, Integer.MAX_VALUE, false);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            ResourceLocation levelKey;
            Player player = (Player)entity;
            Level level = player.level();
            String guidebookGivenTag = "linkingbooks:guidebook_given";
            boolean givingGuidebookOkay = (Boolean)LinkingBooksConfig.GIVE_GUIDEBOOK_ON_FIRST_JOIN.get();
            if (!level.isClientSide() && !player.getTags().contains("linkingbooks:guidebook_given") && givingGuidebookOkay) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)ModItems.GUIDEBOOK.toStack());
                player.addTag("linkingbooks:guidebook_given");
            }
            String reltoBookGivenTag = "linkingbooks:relto_book_given";
            boolean givingReltoBookOkay = (Boolean)LinkingBooksConfig.GIVE_RELTO_BOOK_ON_FIRST_JOIN.get();
            ItemStack reltoBookStack = ModItems.RELTO_BOOK.toStack();
            CompoundTag ownerTag = new CompoundTag();
            ownerTag.putUUID("owner", player.getUUID());
            reltoBookStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)ownerTag));
            if (!level.isClientSide() && !player.getTags().contains("linkingbooks:relto_book_given") && givingReltoBookOkay) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)reltoBookStack);
                player.addTag("linkingbooks:relto_book_given");
            }
            if ((levelKey = level.dimension().location()).getNamespace().equals("linkingbooks") && levelKey.getPath().equals(String.format("relto_%s", player.getUUID()))) {
                String reltoOverworldBookSet = "linkingbooks:relto_overworld_book_set";
                if (!level.isClientSide() && !player.getTags().contains("linkingbooks:relto_overworld_book_set")) {
                    BlockPos lecternPos = new BlockPos(-11, 201, 6);
                    BlockState lecternState = (BlockState)((LinkingLecternBlock)((Object)ModBlocks.LINKING_LECTERN.get())).defaultBlockState().setValue((Property)LinkingLecternBlock.FACING, (Comparable)Direction.SOUTH);
                    level.setBlock(lecternPos, lecternState, 50);
                    LinkingLecternBlockEntity linkingLecternBlockEntity = (LinkingLecternBlockEntity)ModBlockEntityTypes.LINKING_LECTERN.get().create(lecternPos, lecternState);
                    if (linkingLecternBlockEntity != null) {
                        level.setBlockEntity((BlockEntity)linkingLecternBlockEntity);
                        LinkData linkData = new LinkData(Reference.server.overworld().dimension().location(), Reference.server.overworld().getSharedSpawnPos(), Reference.server.overworld().getSharedSpawnAngle(), UUID.randomUUID(), List.of());
                        ItemStack bookItemStack = ModItems.WRITTEN_LINKING_BOOK.toStack();
                        bookItemStack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(new Color(77, 196, 109).getRGB(), false));
                        bookItemStack.set(ModDataComponents.LINK_DATA, (Object)linkData);
                        linkingLecternBlockEntity.insertItem(0, bookItemStack, false);
                        player.addTag("linkingbooks:relto_overworld_book_set");
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTickPre(EntityTickEvent.Pre event) {
        ResourceLocation levelKey;
        Entity entity = event.getEntity();
        Level level = entity.level();
        if (!level.isClientSide() && (levelKey = level.dimension().location()).getNamespace().equals("linkingbooks") && levelKey.getPath().startsWith("relto") && entity.getY() < (double)level.getMinBuildHeight()) {
            LinkData linkData = new LinkData(levelKey, new BlockPos(-11, 200, 23), -180.0f, UUID.randomUUID(), List.of(Reference.getAsResourceLocation("intraage_linking")));
            LinkingUtils.linkEntity(entity, linkData, false);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        MinecraftServer server;
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide() && (server = player.getServer()) != null) {
            LinkingBooksSavedData linkingBooksSavedData = (LinkingBooksSavedData)server.overworld().getDataStorage().computeIfAbsent(LinkingBooksSavedData.factory(), "linkingbooks");
            linkingBooksSavedData.addPlayerDisplayName(player.getUUID(), player.getDisplayName().getString());
            Reference.PLAYER_DISPLAY_NAMES.putAll(linkingBooksSavedData.playerDisplayNames);
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new UpdatePlayerDisplayNamesMessage(Reference.PLAYER_DISPLAY_NAMES), (CustomPacketPayload[])new CustomPacketPayload[0]);
            System.out.println(Reference.AGE_INFO_MAP);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new UpdateClientAgeInfoMapMessage(Reference.AGE_INFO_MAP), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerCraftItem(PlayerEvent.ItemCraftedEvent event) {
        ItemStack itemStack = event.getCrafting();
        if (itemStack.getItem() instanceof ReltoBookItem) {
            CompoundTag ownerTag = new CompoundTag();
            ownerTag.putUUID("owner", event.getEntity().getUUID());
            itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)ownerTag));
        }
    }

    @SubscribeEvent
    public static void onLevelUpdateBrightness(LevelUpdateSkyBrightnessEvent event) {
        Level level = event.getLevel();
        if (!level.isClientSide()) {
            AgeInfo ageInfo;
            ResourceLocation location = level.dimension().location();
            if (level.dimension().location().getNamespace().equals("linkingbooks") && (ageInfo = Reference.AGE_INFO_MAP.get(location)) != null) {
                float lowestValue = GameEventHandler.calculateSkyDarken(level, ageInfo, 1.0f);
                event.setSkyDarken(Math.round(lowestValue * 15.0f));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientLevelGetSkyDarken(ClientLevelGetSkyDarkenEvent event) {
        AgeInfo ageInfo;
        ClientLevel level = event.getClientLevel();
        ResourceLocation location = level.dimension().location();
        if (location.getNamespace().equals("linkingbooks") && (ageInfo = Reference.AGE_INFO_MAP.get(location)) != null) {
            float lowestValue = GameEventHandler.calculateSkyDarken((Level)level, ageInfo, 0.8f);
            event.setSkyDarken(Float.valueOf(lowestValue));
        }
    }

    private static float calculateSkyDarken(Level level, AgeInfo ageInfo, float lowestValue) {
        List<HorizonInfo> horizonInfos = SkyUtils.generateHorizonInfos(ageInfo.skyObject(), level.getDayTime());
        for (HorizonInfo horizonInfo : horizonInfos) {
            float verticalAngle = horizonInfo.getVerticalAngle();
            float transitionAngle = 0.3926991f;
            float lightPercentage = (Mth.clamp((float)(verticalAngle / transitionAngle), (float)-1.0f, (float)1.0f) + 1.0f) / 2.0f;
            float existingValue = Math.min(1.0f, lowestValue);
            float newValue = 1.0f - (float)horizonInfo.getSkyObject().providedLight() * lightPercentage / 15.0f;
            lowestValue = Math.min(existingValue, newValue);
        }
        return lowestValue;
    }
}

