/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.event;

import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.Direction;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.blockentity.LinkingBookHolderBlockEntity;
import thefloydman.linkingbooks.blockentity.ModBlockEntityTypes;
import thefloydman.linkingbooks.client.gui.book.GuiBookManager;
import thefloydman.linkingbooks.client.gui.screen.GuidebookScreen;
import thefloydman.linkingbooks.client.gui.screen.LinkingBookScreen;
import thefloydman.linkingbooks.client.gui.screen.ReltoBookScreen;
import thefloydman.linkingbooks.client.renderer.blockentity.LinkTranslatorRenderer;
import thefloydman.linkingbooks.client.renderer.blockentity.LinkingLecternRenderer;
import thefloydman.linkingbooks.client.renderer.blockentity.MarkerSwitchRenderer;
import thefloydman.linkingbooks.client.renderer.entity.LinkingBookRenderer;
import thefloydman.linkingbooks.client.renderer.entity.model.LinkingBookCoverModel;
import thefloydman.linkingbooks.client.renderer.entity.model.LinkingBookPagesModel;
import thefloydman.linkingbooks.client.renderer.entity.model.ModModelLayers;
import thefloydman.linkingbooks.client.renderer.world.ModDimensionSpecialEffects;
import thefloydman.linkingbooks.entity.ModEntityTypes;
import thefloydman.linkingbooks.integration.ImmersivePortalsIntegration;
import thefloydman.linkingbooks.item.ModItems;
import thefloydman.linkingbooks.linking.LinkEffect;
import thefloydman.linkingbooks.linking.LinkEffectTypes;
import thefloydman.linkingbooks.linking.LinkingUtils;
import thefloydman.linkingbooks.menutype.ModMenuTypes;
import thefloydman.linkingbooks.network.client.PlayOwnLinkingSoundMessage;
import thefloydman.linkingbooks.network.client.TakeScreenshotForLinkingBookMessage;
import thefloydman.linkingbooks.network.client.UpdateClientAgeInfoMapMessage;
import thefloydman.linkingbooks.network.client.UpdateClientDimensionListMessage;
import thefloydman.linkingbooks.network.client.UpdatePlayerDisplayNamesMessage;
import thefloydman.linkingbooks.network.server.AddChunkLoaderMessage;
import thefloydman.linkingbooks.network.server.LinkMessage;
import thefloydman.linkingbooks.network.server.RemoveChunkLoaderMessage;
import thefloydman.linkingbooks.network.server.SaveLinkingPanelImageMessage;

@EventBusSubscriber(modid="linkingbooks", bus=EventBusSubscriber.Bus.MOD)
public class ModEventHandler {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register(LinkingUtils::getLinkingBookColor, new ItemLike[]{ModItems.BLANK_LINKING_BOOK, ModItems.WRITTEN_LINKING_BOOK});
    }

    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(TakeScreenshotForLinkingBookMessage.TYPE, TakeScreenshotForLinkingBookMessage.STREAM_CODEC, TakeScreenshotForLinkingBookMessage::handle);
        registrar.playToClient(UpdateClientDimensionListMessage.TYPE, UpdateClientDimensionListMessage.STREAM_CODEC, UpdateClientDimensionListMessage::handle);
        registrar.playToClient(PlayOwnLinkingSoundMessage.TYPE, PlayOwnLinkingSoundMessage.STREAM_CODEC, PlayOwnLinkingSoundMessage::handle);
        registrar.playToClient(UpdatePlayerDisplayNamesMessage.TYPE, UpdatePlayerDisplayNamesMessage.STREAM_CODEC, UpdatePlayerDisplayNamesMessage::handle);
        registrar.playToClient(UpdateClientAgeInfoMapMessage.TYPE, UpdateClientAgeInfoMapMessage.STREAM_CODEC, UpdateClientAgeInfoMapMessage::handle);
        registrar.playToServer(SaveLinkingPanelImageMessage.TYPE, SaveLinkingPanelImageMessage.STREAM_CODEC, SaveLinkingPanelImageMessage::handle);
        registrar.playToServer(LinkMessage.TYPE, LinkMessage.STREAM_CODEC, LinkMessage::handle);
        registrar.playToServer(AddChunkLoaderMessage.TYPE, AddChunkLoaderMessage.STREAM_CODEC, AddChunkLoaderMessage::handle);
        registrar.playToServer(RemoveChunkLoaderMessage.TYPE, RemoveChunkLoaderMessage.STREAM_CODEC, RemoveChunkLoaderMessage::handle);
    }

    @SubscribeEvent
    static void registerRegistries(NewRegistryEvent event) {
        event.register(LinkEffectTypes.REGISTRY);
    }

    @SubscribeEvent
    public static void registerDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(LinkEffect.REGISTRY_KEY, LinkEffect.CODEC, LinkEffect.CODEC);
    }

    @SubscribeEvent
    public static void registerImmersivePortalsEntities(RegisterEvent event) {
        if (Reference.isImmersivePortalsLoaded()) {
            ImmersivePortalsIntegration.registerImmersivePortalsEntities(event);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        if (Reference.isImmersivePortalsLoaded()) {
            ImmersivePortalsIntegration.registerEntityRenderers(event);
        }
        event.registerEntityRenderer(ModEntityTypes.LINKING_BOOK.get(), LinkingBookRenderer::new);
        event.registerBlockEntityRenderer(ModBlockEntityTypes.LINKING_LECTERN.get(), LinkingLecternRenderer::new);
        event.registerBlockEntityRenderer(ModBlockEntityTypes.LINK_TRANSLATOR.get(), LinkTranslatorRenderer::new);
        event.registerBlockEntityRenderer(ModBlockEntityTypes.MARKER_SWITCH.get(), MarkerSwitchRenderer::new);
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register(ModMenuTypes.LINKING_BOOK.get(), LinkingBookScreen::new);
        event.register(ModMenuTypes.RELTO_BOOK.get(), ReltoBookScreen::new);
        event.register(ModMenuTypes.GUIDEBOOK.get(), GuidebookScreen::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModModelLayers.PAGES, LinkingBookPagesModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.COVER, LinkingBookCoverModel::createBodyLayer);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void addReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new GuiBookManager());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerDimensionSpecialEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(Reference.getAsResourceLocation("age"), (DimensionSpecialEffects)new ModDimensionSpecialEffects.AgeEffects());
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntityTypes.LINKING_LECTERN.get(), (linkingLecternBlockEntity, side) -> linkingLecternBlockEntity.getItemHandler((LinkingBookHolderBlockEntity)((Object)linkingLecternBlockEntity), (Direction)side));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntityTypes.LINK_TRANSLATOR.get(), (linkTranslatorBlockEntity, side) -> linkTranslatorBlockEntity.getItemHandler((LinkingBookHolderBlockEntity)((Object)linkTranslatorBlockEntity), (Direction)side));
    }
}

