/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.item;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.entity.LinkingBookEntity;
import thefloydman.linkingbooks.linking.LinkingUtils;

public class ReltoBookItem
extends Item {
    public ReltoBookItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack itemStack) {
        UUID ownerUUID;
        String username;
        CustomData customData = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        if (customData != null && customData.contains("owner") && (username = Reference.PLAYER_DISPLAY_NAMES.get(ownerUUID = customData.copyTag().getUUID("owner"))) != null) {
            return Component.translatable((String)this.getDescriptionId(itemStack), (Object[])new Object[]{username});
        }
        return Component.translatable((String)"item.linkingbooks.relto_book_generic");
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @Nonnull InteractionHand hand) {
        Tag ownerTag;
        CustomData customData;
        ItemStack heldStack = player.getItemInHand(hand);
        if (!level.isClientSide() && !player.isShiftKeyDown() && (customData = (CustomData)heldStack.get(DataComponents.CUSTOM_DATA)) != null && (ownerTag = customData.copyTag().get("owner")) != null && ownerTag.getType() == TagTypes.getType((int)11)) {
            LinkingUtils.openReltoBookGui((ServerPlayer)player, customData.copyTag().getUUID("owner"));
        }
        return InteractionResultHolder.pass((Object)heldStack);
    }

    public Entity createEntity(@Nonnull Level world, Entity itemEntity, ItemStack stack) {
        LinkingBookEntity entity = new LinkingBookEntity(world, stack.copy());
        entity.setPos(itemEntity.getX(), itemEntity.getY(), itemEntity.getZ());
        entity.setYRot(itemEntity.getYRot());
        entity.setDeltaMovement(itemEntity.getDeltaMovement());
        return entity;
    }

    public boolean hasCustomEntity(@Nonnull ItemStack stack) {
        return true;
    }
}

