/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.linking;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.linking.LinkEffectType;
import thefloydman.linkingbooks.linking.LinkEffectTypes;

public record LinkEffect(LinkEffectType type, BiFunction<Entity, LinkData, Boolean> canStartLink, BiFunction<Entity, LinkData, Boolean> canFinishLink, BiConsumer<Entity, LinkData> onLinkStart, BiConsumer<Entity, LinkData> onLinkEnd) {
    public static final ResourceKey<Registry<LinkEffect>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"linkingbooks", (String)"linkeffect"));
    public static final Codec<LinkEffect> CODEC = Codec.of(LinkEffect::encode, LinkEffect::decode);

    private static <T> DataResult<T> encode(LinkEffect linkEffect, DynamicOps<T> ops, T prefix) {
        return linkEffect.type().codec().encode((Object)linkEffect.type(), ops, prefix);
    }

    private static <T> DataResult<Pair<LinkEffect, T>> decode(DynamicOps<T> ops, T input) {
        DataResult newPair;
        ResourceLocation typeResourceLocation;
        LinkEffectType linkEffectType;
        JsonElement typeElement;
        DataResult typePair;
        JsonObject topLevelJsonObject = ((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)).getAsJsonObject();
        if (topLevelJsonObject.has("type") && (typePair = ResourceLocation.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)(typeElement = topLevelJsonObject.get("type")))).isSuccess() && typePair.result().isPresent() && (linkEffectType = (LinkEffectType)LinkEffectTypes.REGISTRY.get(typeResourceLocation = (ResourceLocation)((Pair)typePair.result().get()).getFirst())) != null && (newPair = linkEffectType.codec().decode(ops, input)).isSuccess() && newPair.result().isPresent()) {
            LinkEffectType specificLinkEffectType = (LinkEffectType)((Pair)newPair.result().get()).getFirst();
            return new DataResult.Success((Object)Pair.of((Object)new LinkEffect(specificLinkEffectType, LinkEffect.getCanStartLink(specificLinkEffectType), LinkEffect.getCanFinishLink(specificLinkEffectType), LinkEffect.getOnLinkStart(specificLinkEffectType), LinkEffect.getOnLinkEnd(specificLinkEffectType)), input), Lifecycle.stable());
        }
        return new DataResult.Error(() -> "Could not parse Link Effect.", Optional.empty(), Lifecycle.stable());
    }

    private static BiFunction<Entity, LinkData, Boolean> getCanStartLink(LinkEffectType type) {
        return type::canStartLink;
    }

    private static BiFunction<Entity, LinkData, Boolean> getCanFinishLink(LinkEffectType type) {
        return type::canFinishLink;
    }

    private static BiConsumer<Entity, LinkData> getOnLinkStart(LinkEffectType type) {
        return type::onLinkStart;
    }

    private static BiConsumer<Entity, LinkData> getOnLinkEnd(LinkEffectType type) {
        return type::onLinkEnd;
    }

    @Nullable
    public static LinkEffect getLinkEffect(@Nonnull ResourceLocation resourceLocation) {
        Optional optionalRegistry = Reference.server.registryAccess().registry(REGISTRY_KEY);
        if (optionalRegistry.isPresent()) {
            Registry linkEffectRegistry = (Registry)optionalRegistry.get();
            return (LinkEffect)linkEffectRegistry.get(resourceLocation);
        }
        return null;
    }
}

