/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.menutype;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.menutype.ModMenuTypes;
import thefloydman.linkingbooks.network.server.AddChunkLoaderMessage;
import thefloydman.linkingbooks.network.server.RemoveChunkLoaderMessage;

public class ReltoBookMenuType
extends AbstractContainerMenu {
    public UUID owner = UUID.randomUUID();

    public ReltoBookMenuType(int containerId, Inventory playerInventory) {
        super(ModMenuTypes.RELTO_BOOK.get(), containerId);
    }

    public ReltoBookMenuType(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf extraData) {
        super(ModMenuTypes.LINKING_BOOK.get(), containerId);
        this.owner = extraData.readUUID();
        LinkData linkData = new LinkData(Reference.getAsResourceLocation(String.format("relto_%s", this.owner)), new BlockPos(-11, 200, 23), -90.0f, UUID.randomUUID(), List.of(Reference.getAsResourceLocation("intraage_linking")));
        if (Reference.isImmersivePortalsLoaded()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new AddChunkLoaderMessage(linkData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean stillValid(@Nonnull Player player) {
        return true;
    }

    public void removed(@Nonnull Player player) {
        if (Reference.isImmersivePortalsLoaded()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RemoveChunkLoaderMessage(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        super.removed(player);
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int slotIndex) {
        return ItemStack.EMPTY;
    }
}

