/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.network.server;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import thefloydman.linkingbooks.world.storage.LinkingBooksSavedData;

public record SaveLinkingPanelImageMessage(CompoundTag image, UUID uuid) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SaveLinkingPanelImageMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"linkingbooks", (String)"save_linking_book_screenshot"));
    public static final StreamCodec<ByteBuf, SaveLinkingPanelImageMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, SaveLinkingPanelImageMessage::image, (StreamCodec)UUIDUtil.STREAM_CODEC, SaveLinkingPanelImageMessage::uuid, SaveLinkingPanelImageMessage::new);

    public static void handle(SaveLinkingPanelImageMessage data, IPayloadContext context) {
        try {
            LinkingBooksSavedData worldData = (LinkingBooksSavedData)context.player().getServer().overworld().getDataStorage().computeIfAbsent(LinkingBooksSavedData.factory(), "linkingbooks");
            worldData.addLinkingPanelImage(data.uuid(), data.image());
        }
        catch (NullPointerException exception) {
            LogUtils.getLogger().warn(exception.getMessage());
        }
    }

    @Nonnull
    public CustomPacketPayload.Type<SaveLinkingPanelImageMessage> type() {
        return TYPE;
    }
}

