/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.world.generation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.world.generation.CloudInfo;
import thefloydman.linkingbooks.world.sky.SkyObject;

public record AgeInfo(int version, ResourceLocation id, Component name, UUID owner, boolean overrideBiomeSkyColor, int skyColor, int fogColor, @Nonnull SkyObject skyObject, List<CloudInfo> cloudInfos) {
    public static final int SCHEMA_VERSION = 1;
    public static final AgeInfo DUMMY = new AgeInfo(1, Reference.getAsResourceLocation("dummy"), (Component)Component.translatable((String)"age.linkingbooks.name.unnamed"), UUID.randomUUID(), false, 8103167, 8103167, SkyObject.DUMMY, List.of());
    public static final Codec<AgeInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("version", (Object)0).forGetter(AgeInfo::version), (App)ResourceLocation.CODEC.optionalFieldOf("id", (Object)Reference.getAsResourceLocation("dummy")).forGetter(AgeInfo::id), (App)Codec.of(AgeInfo::encodeComponent, AgeInfo::decodeComponent).optionalFieldOf("name", (Object)Component.translatable((String)"age.linkingbooks.name.unnamed")).forGetter(AgeInfo::name), (App)UUIDUtil.CODEC.optionalFieldOf("owner", (Object)UUID.randomUUID()).forGetter(AgeInfo::owner), (App)Codec.BOOL.optionalFieldOf("override_biome_sky_color", (Object)false).forGetter(AgeInfo::overrideBiomeSkyColor), (App)Codec.INT.optionalFieldOf("sky_color", (Object)8103167).forGetter(AgeInfo::skyColor), (App)Codec.INT.optionalFieldOf("fog_color", (Object)8103167).forGetter(AgeInfo::fogColor), (App)SkyObject.CODEC.optionalFieldOf("sky_object", (Object)SkyObject.DUMMY).forGetter(AgeInfo::skyObject), (App)Codec.list(CloudInfo.CODEC).optionalFieldOf("cloud_infos", List.of()).forGetter(AgeInfo::cloudInfos)).apply((Applicative)instance, AgeInfo::new));
    public static final StreamCodec<ByteBuf, AgeInfo> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);

    public AgeInfo(int version, ResourceLocation id, Component name, UUID owner, boolean overrideBiomeSkyColor, int skyColor, int fogColor, @Nonnull SkyObject skyObject, List<CloudInfo> cloudInfos) {
        this.version = version;
        this.id = id;
        this.name = name;
        this.owner = owner;
        this.overrideBiomeSkyColor = overrideBiomeSkyColor;
        this.skyColor = skyColor;
        this.fogColor = fogColor;
        this.skyObject = skyObject;
        this.cloudInfos = cloudInfos.stream().sorted((a, b) -> Float.compare(a.height(), b.height())).toList();
    }

    private static <T> DataResult<T> encodeComponent(Component component, DynamicOps<T> ops, T input) {
        JsonObject topLevelJsonObject = new JsonObject();
        boolean translatable = component.getContents() instanceof TranslatableContents;
        topLevelJsonObject.addProperty("contents", translatable ? ((TranslatableContents)component.getContents()).getKey() : component.getString());
        topLevelJsonObject.addProperty("translatable", Boolean.valueOf(translatable));
        return ExtraCodecs.JSON.encode((Object)topLevelJsonObject, ops, input);
    }

    private static <T> DataResult<Pair<Component, T>> decodeComponent(DynamicOps<T> ops, T input) {
        JsonElement contentsElement;
        DataResult contentsPair;
        JsonElement translatableElement;
        DataResult translatablePair;
        JsonObject topLevelJsonObject = ((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)).getAsJsonObject();
        boolean translatable = false;
        if (topLevelJsonObject.has("translatable") && (translatablePair = Codec.BOOL.decode((DynamicOps)JsonOps.INSTANCE, (Object)(translatableElement = topLevelJsonObject.get("translatable")))).isSuccess() && translatablePair.result().isPresent()) {
            translatable = (Boolean)((Pair)translatablePair.result().get()).getFirst();
        }
        if (topLevelJsonObject.has("contents") && (contentsPair = Codec.STRING.decode((DynamicOps)JsonOps.INSTANCE, (Object)(contentsElement = topLevelJsonObject.get("contents")))).isSuccess() && contentsPair.result().isPresent()) {
            MutableComponent component = translatable ? Component.translatable((String)((String)((Pair)contentsPair.result().get()).getFirst())) : Component.literal((String)((String)((Pair)contentsPair.result().get()).getFirst()));
            return new DataResult.Success((Object)Pair.of((Object)component, input), Lifecycle.stable());
        }
        return new DataResult.Error(() -> "Could not parse Component.", Optional.empty(), Lifecycle.stable());
    }

    public AgeInfo updateVersion() {
        int version = this.version();
        ResourceLocation id = this.id();
        Component name = this.name();
        UUID owner = this.owner();
        boolean overrideBiomeSkyColor = this.overrideBiomeSkyColor();
        int skyColor = this.skyColor();
        int fogColor = this.fogColor();
        SkyObject skyObject = this.skyObject();
        List<CloudInfo> cloudInfos = this.cloudInfos();
        if (version == 0) {
            version = 1;
            if (id.getNamespace().equals("linkingbooks") && id.getPath().startsWith("relto_")) {
                overrideBiomeSkyColor = false;
                skyColor = new Color(69, 7, 94).getRGB();
                fogColor = new Color(54, 42, 133).getRGB();
                SkyObject self = SkyObject.self(0, 12000L, 0.7853982f, 0x2EE000L, 0.0f, 1.0f, List.of());
                SkyObject innerPlanet = new SkyObject(Reference.getAsResourceLocation("inner_planet"), 0, Reference.getAsResourceLocation("textures/environment/sun"), 0L, 0.0f, 24000L, 0.0f, 0.25f, 5.0f, true, new Color(182, 182, 182).getRGB(), List.of());
                skyObject = new SkyObject(Reference.getAsResourceLocation("sun"), 15, Reference.getAsResourceLocation("textures/environment/sun"), 0L, 0.0f, 0L, 0.0f, 0.0f, 30.0f, true, new Color(255, 245, 138).getRGB(), List.of(self, innerPlanet));
                cloudInfos = List.of(new CloudInfo(193.0f, new Color(191, 48, 0).getRGB()), new CloudInfo(188.0f, new Color(107, 29, 3).getRGB()), new CloudInfo(183.0f, new Color(84, 0, 0).getRGB()));
            }
        }
        if (version == 1) {
            // empty if block
        }
        return new AgeInfo(version, id, name, owner, overrideBiomeSkyColor, skyColor, fogColor, skyObject, cloudInfos);
    }
}

