/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.world.generation;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.world.generation.ModBiomes;
import thefloydman.linkingbooks.world.generation.PrefabChunkGenerator;

public class LinkingBooksDimensionFactory {
    public static LevelStem createDimension(MinecraftServer server, ResourceKey<LevelStem> levelStemKey, ResourceKey<DimensionType> dimensionType) {
        final ArrayList biomes = Lists.newArrayList((Object[])new ResourceKey[]{Biomes.JUNGLE, Biomes.DESERT});
        Holder.Reference noiseGeneratorSettings = server.registryAccess().registryOrThrow(Registries.NOISE_SETTINGS).getHolderOrThrow(NoiseGeneratorSettings.OVERWORLD);
        MultiNoiseBiomeSourceParameterList.Preset preset = new MultiNoiseBiomeSourceParameterList.Preset(Reference.getAsResourceLocation("overworld_like"), new MultiNoiseBiomeSourceParameterList.Preset.SourceProvider(){

            @Nonnull
            public <T> Climate.ParameterList<T> apply(@Nonnull Function<ResourceKey<Biome>, T> valueGetter) {
                return new Climate.ParameterList(biomes.stream().map(biome -> Pair.of((Object)Climate.parameters((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f), valueGetter.apply((ResourceKey<Biome>)biome))).toList());
            }
        });
        HolderLookup.RegistryLookup biomeRegistryLookup = server.registryAccess().lookupOrThrow(Registries.BIOME);
        MultiNoiseBiomeSourceParameterList parameterList = new MultiNoiseBiomeSourceParameterList(preset, (HolderGetter)biomeRegistryLookup);
        MultiNoiseBiomeSource multiNoiseBiomeSource = MultiNoiseBiomeSource.createFromPreset((Holder)Holder.direct((Object)parameterList));
        NoiseBasedChunkGenerator chunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)multiNoiseBiomeSource, (Holder)noiseGeneratorSettings);
        return new LevelStem(LinkingBooksDimensionFactory.getDimensionTypeHolder(server, dimensionType), (ChunkGenerator)chunkGenerator);
    }

    public static LevelStem createRelto(MinecraftServer server, ResourceKey<LevelStem> levelStemKey, ResourceKey<DimensionType> dimensionType) {
        Optional biomeReference = server.registryAccess().lookupOrThrow(Registries.BIOME).get(ModBiomes.RELTO);
        Holder biomeHolder = (Holder)biomeReference.orElseGet(() -> server.registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(Biomes.THE_VOID));
        PrefabChunkGenerator chunkGenerator = new PrefabChunkGenerator((Holder<Biome>)biomeHolder);
        return new LevelStem(LinkingBooksDimensionFactory.getDimensionTypeHolder(server, dimensionType), (ChunkGenerator)chunkGenerator);
    }

    public static Holder<DimensionType> getDimensionTypeHolder(MinecraftServer server, ResourceKey<DimensionType> dimensionType) {
        return server.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE).getHolderOrThrow(dimensionType);
    }
}

