/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.world.storage;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.network.PacketDistributor;
import thefloydman.linkingbooks.Reference;
import thefloydman.linkingbooks.component.LinkData;
import thefloydman.linkingbooks.network.client.UpdateClientAgeInfoMapMessage;
import thefloydman.linkingbooks.world.generation.AgeInfo;

public class LinkingBooksSavedData
extends SavedData {
    public final Map<UUID, CompoundTag> linkingPanelImages = new HashMap<UUID, CompoundTag>();
    public final Map<BlockPos, LinkData> linkingPortals = new HashMap<BlockPos, LinkData>();
    public final Set<AgeInfo> ages = Sets.newHashSet();
    public final Map<UUID, String> playerDisplayNames = new HashMap<UUID, String>();
    public static final Codec<LinkingBooksSavedData> CODEC = RecordCodecBuilder.create(codecBuilderInstance -> codecBuilderInstance.group((App)Codec.list((Codec)CompoundTag.CODEC).fieldOf("linkingPanelImages").forGetter(linkingBooksSavedData -> linkingBooksSavedData.linkingPanelImages.entrySet().stream().map(entry -> {
        CompoundTag compoundTag = (CompoundTag)entry.getValue();
        compoundTag.putUUID("uuid", (UUID)entry.getKey());
        return compoundTag;
    }).toList()), (App)Codec.list((Codec)CompoundTag.CODEC).fieldOf("linking_portals").forGetter(linkingBooksSavedData -> linkingBooksSavedData.linkingPortals.entrySet().stream().map(entry -> {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("portal_pos", NbtUtils.writeBlockPos((BlockPos)((BlockPos)entry.getKey())));
        LinkData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((LinkData)entry.getValue())).ifSuccess(tag -> compoundTag.put("link_data", tag));
        return compoundTag;
    }).toList())).apply((Applicative)codecBuilderInstance, (linkingPanelImagesList, linkingPortalsList) -> {
        HashMap<UUID, CompoundTag> linkingPanelImages = new HashMap<UUID, CompoundTag>();
        for (CompoundTag compoundTag : linkingPanelImagesList) {
            UUID uuid = compoundTag.getUUID("uuid");
            compoundTag.remove("uuid");
            linkingPanelImages.put(uuid, compoundTag);
        }
        HashMap<BlockPos, LinkData> linkingPortals = new HashMap<BlockPos, LinkData>();
        for (CompoundTag compound : linkingPortalsList) {
            BlockPos pos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"portal_pos").orElseGet(() -> BlockPos.ZERO);
            try {
                LinkData linkData = (LinkData)LinkData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.getCompound("link_data")).getOrThrow();
                linkingPortals.put(pos, linkData);
            }
            catch (IllegalStateException e) {
                LogUtils.getLogger().warn(e.getMessage());
            }
        }
        return new LinkingBooksSavedData(linkingPanelImages, linkingPortals);
    }));

    private LinkingBooksSavedData() {
    }

    public LinkingBooksSavedData(Map<UUID, CompoundTag> linkingPanelImages, Map<BlockPos, LinkData> linkingPortals) {
    }

    public static SavedData.Factory<LinkingBooksSavedData> factory() {
        return new SavedData.Factory(LinkingBooksSavedData::new, LinkingBooksSavedData::load);
    }

    public boolean addLinkingPanelImage(UUID uuid, CompoundTag image) {
        this.linkingPanelImages.put(uuid, image);
        this.setDirty();
        return true;
    }

    public boolean removeLinkingPanelImage(UUID uuid) {
        if (!this.linkingPanelImages.containsKey(uuid)) {
            return false;
        }
        this.linkingPanelImages.remove(uuid);
        this.setDirty();
        return true;
    }

    public CompoundTag getLinkingPanelImage(UUID uuid) {
        return this.linkingPanelImages.get(uuid);
    }

    public void addAge(AgeInfo age) {
        Set matchingAgeInfos = this.ages.stream().filter(ageInfo -> ageInfo.id().equals((Object)age.id())).collect(Collectors.toSet());
        this.ages.removeAll(matchingAgeInfos);
        this.ages.add(age);
        Reference.AGE_INFO_MAP.putAll(this.ages.stream().collect(Collectors.toMap(AgeInfo::id, ageInfo -> ageInfo)));
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new UpdateClientAgeInfoMapMessage(Stream.of(age).collect(Collectors.toMap(AgeInfo::id, ageInfo -> ageInfo))), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.setDirty();
    }

    public boolean addLinkingPortalData(BlockPos pos, LinkData linkData) {
        this.linkingPortals.put(new BlockPos((Vec3i)pos), linkData);
        this.setDirty();
        return true;
    }

    public boolean removeLinkingPortalData(BlockPos pos) {
        if (!this.linkingPortals.containsKey(pos)) {
            return false;
        }
        this.linkingPortals.remove(pos);
        this.setDirty();
        return true;
    }

    public LinkData getLinkingPortalData(BlockPos pos) {
        return this.linkingPortals.get(pos);
    }

    public boolean addPlayerDisplayName(UUID uuid, String displayName) {
        this.playerDisplayNames.put(uuid, displayName);
        this.setDirty();
        return true;
    }

    public String getPlayerDisplayName(UUID uuid) {
        return this.playerDisplayNames.get(uuid);
    }

    @Nonnull
    public CompoundTag save(CompoundTag nbt, @Nonnull HolderLookup.Provider provider) {
        ListTag imageList = new ListTag();
        this.linkingPanelImages.forEach((uuid, image) -> {
            image.putUUID("uuid", uuid);
            imageList.add(image);
        });
        nbt.put("linkingPanelImages", (Tag)imageList);
        ListTag portalList = new ListTag();
        this.linkingPortals.forEach((pos, linkData) -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.put("portal_pos", NbtUtils.writeBlockPos((BlockPos)pos));
            LinkData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, linkData).ifSuccess(tag -> compoundTag.put("link_data", tag));
            portalList.add((Object)compoundTag);
        });
        nbt.put("linking_portals", (Tag)portalList);
        ListTag ageList = new ListTag();
        List<Tag> tags = this.ages.stream().map(ageInfo -> {
            DataResult dataResult = AgeInfo.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, ageInfo);
            if (dataResult.result().isPresent()) {
                return (Tag)dataResult.result().get();
            }
            return null;
        }).filter(Objects::nonNull).toList();
        ageList.addAll(tags);
        nbt.put("ages", (Tag)ageList);
        ListTag displayNamesList = new ListTag();
        this.playerDisplayNames.forEach((uuid, displayName) -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putUUID("uuid", uuid);
            compoundTag.putString("display_name", displayName);
            displayNamesList.add((Object)compoundTag);
        });
        nbt.put("player_display_names", (Tag)displayNamesList);
        return nbt;
    }

    public static LinkingBooksSavedData load(CompoundTag nbt, HolderLookup.Provider provider) {
        UUID uuid;
        CompoundTag compound;
        ListTag list;
        LinkingBooksSavedData data = new LinkingBooksSavedData();
        if (nbt.contains("linkingPanelImages", 9)) {
            list = nbt.getList("linkingPanelImages", 10);
            for (Tag item : list) {
                compound = (CompoundTag)item;
                if (!compound.contains("uuid", 11)) continue;
                uuid = compound.getUUID("uuid");
                data.linkingPanelImages.put(uuid, compound);
            }
        }
        if (nbt.contains("linking_portals", 9)) {
            list = nbt.getList("linking_portals", 10);
            for (Tag item : list) {
                compound = (CompoundTag)item;
                BlockPos pos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"portal_pos").orElseGet(() -> BlockPos.ZERO);
                try {
                    LinkData linkData = (LinkData)LinkData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.getCompound("link_data")).getOrThrow();
                    data.linkingPortals.put(pos, linkData);
                }
                catch (IllegalStateException exception) {
                    LogUtils.getLogger().warn(exception.getMessage());
                }
            }
        }
        if (nbt.contains("ages", 9)) {
            list = nbt.getList("ages", 10);
            data.ages.addAll(list.stream().map(tag -> {
                DataResult pair = AgeInfo.CODEC.decode((DynamicOps)NbtOps.INSTANCE, tag);
                if (pair.isSuccess() && pair.result().isPresent()) {
                    return (AgeInfo)((Pair)pair.result().get()).getFirst();
                }
                return AgeInfo.DUMMY;
            }).toList());
        }
        if (nbt.contains("player_display_names", 9)) {
            list = nbt.getList("player_display_names", 10);
            for (Tag item : list) {
                compound = (CompoundTag)item;
                if (!compound.contains("uuid", 11) || !compound.contains("display_name", 8)) continue;
                uuid = compound.getUUID("uuid");
                String displayName = compound.getString("display_name");
                data.playerDisplayNames.put(uuid, displayName);
            }
        }
        Reference.AGE_INFO_MAP.putAll(data.ages.stream().collect(Collectors.toMap(AgeInfo::id, ageInfo -> ageInfo)));
        return data;
    }
}

