/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.block;

import io.netty.buffer.Unpooled;
import java.util.Optional;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.impl.screenhandler.Networking;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import thefloydman.linkingbooks.api.component.ColorComponent;
import thefloydman.linkingbooks.api.component.LinkDataComponent;
import thefloydman.linkingbooks.block.LinkingLecternBlock;
import thefloydman.linkingbooks.block.entity.LinkTranslatorBlockEntity;
import thefloydman.linkingbooks.block.entity.ModBlockEntityTypes;
import thefloydman.linkingbooks.component.ModComponents;
import thefloydman.linkingbooks.config.ModConfig;
import thefloydman.linkingbooks.entity.LinkingBookEntity;
import thefloydman.linkingbooks.integration.ImmersivePortalsIntegration;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;
import thefloydman.linkingbooks.linking.LinkEffects;
import thefloydman.linkingbooks.screen.LinkingBookScreenHandler;
import thefloydman.linkingbooks.util.LinkingPortalUtils;
import thefloydman.linkingbooks.util.Reference;

public class LinkTranslatorBlock
extends class_2383
implements class_2343 {
    public static final class_2746 HAS_BOOK = class_2741.field_17393;
    public static final class_265 NORTH_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)1.0), class_2248.method_9541((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)4.0, (double)2.0), class_2248.method_9541((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), class_2248.method_9541((double)0.0, (double)12.0, (double)1.0, (double)16.0, (double)16.0, (double)2.0)});
    public static final class_265 EAST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0), (class_265[])new class_265[]{class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), class_2248.method_9541((double)14.0, (double)0.0, (double)0.0, (double)15.0, (double)4.0, (double)16.0), class_2248.method_9541((double)15.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)14.0, (double)12.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0)});
    public static final class_265 SOUTH_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)5.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)4.0, (double)15.0), class_2248.method_9541((double)0.0, (double)11.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0, (double)15.0)});
    public static final class_265 WEST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)5.0, (double)16.0), class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)2.0, (double)4.0, (double)16.0), class_2248.method_9541((double)0.0, (double)11.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), class_2248.method_9541((double)1.0, (double)12.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0)});

    protected LinkTranslatorBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)HAS_BOOK, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, HAS_BOOK});
    }

    public boolean method_9526(class_2680 state) {
        return true;
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 generic = world.method_8321(pos);
        if (generic instanceof LinkTranslatorBlockEntity) {
            LinkTranslatorBlockEntity blockEntity = (LinkTranslatorBlockEntity)generic;
            if (!world.method_8608() && hand.equals((Object)class_1268.field_5808)) {
                class_1799 stack;
                class_1792 item;
                if (player.method_5715()) {
                    if (world.method_8320(pos).method_26204() instanceof LinkingLecternBlock) {
                        class_1799 stack2 = player.method_5998(hand);
                        if (stack2.method_7909() instanceof WrittenLinkingBookItem && !blockEntity.hasBook()) {
                            blockEntity.setBook(stack2);
                            player.field_7498.method_7623();
                        } else if (stack2.method_7960() && blockEntity.hasBook()) {
                            player.method_7270(blockEntity.getBook());
                            player.field_7498.method_7623();
                            blockEntity.setBook(class_1799.field_8037);
                        }
                    }
                } else if (blockEntity.hasBook() && (item = (stack = blockEntity.getBook()).method_7909()) instanceof WrittenLinkingBookItem) {
                    LinkDataComponent linkData = (LinkDataComponent)ModComponents.ITEM_LINK_DATA.get((Object)stack);
                    ColorComponent color = (ColorComponent)ModComponents.ITEM_COLOR.get((Object)stack);
                    if (linkData != null && color != null) {
                        class_2540 buf = new class_2540(Unpooled.buffer());
                        blockEntity.writeScreenOpeningData((class_3222)player, buf);
                        Networking.sendOpenPacket((class_3222)((class_3222)player), (ExtendedScreenHandlerFactory)blockEntity, (class_1703)new LinkingBookScreenHandler(0, player.field_7514, buf), (int)0);
                    }
                }
            }
        }
        return class_1269.field_5811;
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)ctx.method_8042().method_10153());
    }

    public class_2586 method_10123(class_1922 world) {
        return ModBlockEntityTypes.LINK_TRANSLATOR.method_11032();
    }

    public void method_9567(class_1937 world, class_2338 blockPos, class_2680 blockState, class_1309 livingEntity, class_1799 itemStack) {
        super.method_9567(world, blockPos, blockState, livingEntity, itemStack);
        for (int x = blockPos.method_10263() - 32; x < blockPos.method_10263() + 32; ++x) {
            for (int y = blockPos.method_10264() - 32; y < blockPos.method_10264() + 32; ++y) {
                for (int z = blockPos.method_10260() - 32; z < blockPos.method_10260() + 32; ++z) {
                    LinkTranslatorBlockEntity translator;
                    class_2338 currentPos = new class_2338(x, y, z);
                    class_2586 blockEntity = world.method_8321(currentPos);
                    if (blockEntity == null || !(blockEntity instanceof LinkTranslatorBlockEntity) || !(translator = (LinkTranslatorBlockEntity)blockEntity).hasBook()) continue;
                    LinkDataComponent linkData = (LinkDataComponent)ModComponents.ITEM_LINK_DATA.get((Object)translator.getBook());
                    this.tryMakePortalInDirection(world, currentPos, class_2350.field_11043, linkData, translator);
                    this.tryMakePortalInDirection(world, currentPos, class_2350.field_11034, linkData, translator);
                    this.tryMakePortalInDirection(world, currentPos, class_2350.field_11035, linkData, translator);
                    this.tryMakePortalInDirection(world, currentPos, class_2350.field_11039, linkData, translator);
                }
            }
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (state.method_26204() != newState.method_26204() && !world.method_8608()) {
            class_2586 tileEntity = world.method_8321(pos);
            if (tileEntity instanceof LinkTranslatorBlockEntity) {
                class_1799 stack;
                LinkTranslatorBlockEntity translatorTE = (LinkTranslatorBlockEntity)tileEntity;
                if (Reference.isImmersivePortalsLoaded()) {
                    ImmersivePortalsIntegration.deleteLinkingPortals(translatorTE);
                }
                if (translatorTE.hasBook() && (stack = translatorTE.getBook()).method_7909() instanceof WrittenLinkingBookItem) {
                    LinkingBookEntity entity = new LinkingBookEntity(world, stack.method_7972());
                    entity.method_5641((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, ((class_2350)state.method_11654((class_2769)field_11177)).method_10144() + 180.0f, 0.0f);
                    world.method_8649((class_1297)entity);
                }
            }
            for (int x = pos.method_10263() - 32; x < pos.method_10263() + 32; ++x) {
                for (int y = pos.method_10264() - 32; y < pos.method_10264() + 32; ++y) {
                    for (int z = pos.method_10260() - 32; z < pos.method_10260() + 32; ++z) {
                        boolean deletePortal;
                        class_2338 currentPos = new class_2338(x, y, z);
                        class_2586 blockEntity = world.method_8321(currentPos);
                        if (blockEntity == null || !(blockEntity instanceof LinkTranslatorBlockEntity)) continue;
                        LinkTranslatorBlockEntity translator = (LinkTranslatorBlockEntity)blockEntity;
                        boolean bl = deletePortal = !this.canPortalExistInDirection(world, currentPos, class_2350.field_11043) && !this.canPortalExistInDirection(world, currentPos, class_2350.field_11034) && !this.canPortalExistInDirection(world, currentPos, class_2350.field_11035) && !this.canPortalExistInDirection(world, currentPos, class_2350.field_11039);
                        if (!deletePortal || !Reference.isImmersivePortalsLoaded()) continue;
                        ImmersivePortalsIntegration.deleteLinkingPortals(translator);
                    }
                }
            }
        }
        super.method_9536(state, world, pos, newState, isMoving);
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockView, class_2338 blockPos, class_3726 shapeContext) {
        switch ((class_2350)blockState.method_11654((class_2769)field_11177)) {
            case field_11034: {
                return EAST_SHAPE;
            }
            case field_11035: {
                return SOUTH_SHAPE;
            }
            case field_11039: {
                return WEST_SHAPE;
            }
        }
        return NORTH_SHAPE;
    }

    private boolean canPortalExistInDirection(class_1937 world, class_2338 pos, class_2350 direction) {
        Optional<LinkingPortalUtils> optional = LinkingPortalUtils.canMakePortal((class_1936)world, pos.method_10093(direction), class_2350.class_2351.field_11048);
        return optional.isPresent();
    }

    private void tryMakePortalInDirection(class_1937 world, class_2338 pos, class_2350 direction, LinkDataComponent linkData, LinkTranslatorBlockEntity blockEntity) {
        if (world.method_27983().method_29177().equals((Object)linkData.getDimension()) && !linkData.getLinkEffects().contains(LinkEffects.INTRAAGE_LINKING)) {
            return;
        }
        Optional<LinkingPortalUtils> optional = LinkingPortalUtils.canMakePortal((class_1936)world, pos.method_10093(direction), class_2350.class_2351.field_11048);
        if (optional.isPresent()) {
            LinkingPortalUtils util = optional.get();
            ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
            if (Reference.isImmersivePortalsLoaded() && config.useImmersivePortalsForLinkingPortals) {
                double x = util.axis == class_2350.class_2351.field_11048 ? (double)util.lowerCorner.method_10263() + (double)util.width / 2.0 - ((double)util.width - 1.0) : (double)util.lowerCorner.method_10263() + 0.5;
                double y = (double)util.lowerCorner.method_10264() + (double)util.height / 2.0;
                double z = util.axis == class_2350.class_2351.field_11048 ? (double)util.lowerCorner.method_10260() + 0.5 : (double)util.lowerCorner.method_10260() + (double)util.width / 2.0;
                ImmersivePortalsIntegration.addImmersivePortal(world, new double[]{x, y, z}, util.width, util.height, util.axis, linkData, blockEntity);
            } else {
                util.createPortal(linkData);
            }
        }
    }
}

