/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.integration;

import com.qouteall.immersive_portals.ClientWorldLoader;
import com.qouteall.immersive_portals.chunk_loading.ChunkVisibilityManager;
import com.qouteall.immersive_portals.chunk_loading.DimensionalChunkPos;
import com.qouteall.immersive_portals.chunk_loading.NewChunkTrackingGraph;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.PortalManipulation;
import com.qouteall.immersive_portals.render.GuiPortalRendering;
import com.qouteall.immersive_portals.render.MyRenderHelper;
import com.qouteall.immersive_portals.render.PortalEntityRenderer;
import com.qouteall.immersive_portals.render.context_management.WorldRenderInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_4048;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import thefloydman.linkingbooks.api.component.LinkDataComponent;
import thefloydman.linkingbooks.block.entity.LinkTranslatorBlockEntity;
import thefloydman.linkingbooks.component.ModComponents;
import thefloydman.linkingbooks.config.ModConfig;
import thefloydman.linkingbooks.entity.LinkingPortalEntity;
import thefloydman.linkingbooks.item.ModItems;
import thefloydman.linkingbooks.util.Reference;

public class ImmersivePortalsIntegration {
    private static Map<UUID, ChunkVisibilityManager.ChunkLoader> chunkLoaders = new HashMap<UUID, ChunkVisibilityManager.ChunkLoader>();
    public static class_1299<LinkingPortalEntity> linkingPortalEntityType;

    public static void addChunkLoader(LinkDataComponent linkData, class_3222 player) {
        ImmersivePortalsIntegration.removeChunkLoader(linkData, player);
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        ChunkVisibilityManager.ChunkLoader chunkLoader = new ChunkVisibilityManager.ChunkLoader(new DimensionalChunkPos(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)linkData.getDimension()), new class_1923(linkData.getPosition())), config.linkingPanelChunkLoadRadius);
        chunkLoaders.put(linkData.getUUID(), chunkLoader);
        NewChunkTrackingGraph.addPerPlayerAdditionalChunkLoader((class_3222)player, (ChunkVisibilityManager.ChunkLoader)chunkLoader);
    }

    public static void removeChunkLoader(LinkDataComponent linkData, class_3222 player) {
        ChunkVisibilityManager.ChunkLoader chunkLoader = chunkLoaders.remove(linkData.getUUID());
        if (chunkLoader != null) {
            NewChunkTrackingGraph.removePerPlayerAdditionalChunkLoader((class_3222)player, (ChunkVisibilityManager.ChunkLoader)chunkLoader);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void renderGuiPortal(LinkDataComponent linkData, class_276 frameBuffer, class_310 client, class_4587 matrixStack, int x, int y, int width, int height) {
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        class_1159 cameraTransformation = new class_1159();
        cameraTransformation.method_22668();
        cameraTransformation.method_22670(class_1160.field_20705.method_23214(linkData.getRotation() + 180.0f));
        WorldRenderInfo worldRenderInfo = new WorldRenderInfo(ClientWorldLoader.getWorld((class_5321)class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)linkData.getDimension())), new class_243((double)linkData.getPosition().method_10263() + 0.5, (double)linkData.getPosition().method_10264() + 1.5, (double)linkData.getPosition().method_10260() + 0.5), cameraTransformation, null, config.linkingPanelChunkRenderDistance, true);
        GuiPortalRendering.submitNextFrameRendering((WorldRenderInfo)worldRenderInfo, (class_276)frameBuffer);
        MyRenderHelper.drawFramebuffer((class_276)frameBuffer, (boolean)false, (boolean)false, (float)((float)x * (float)client.method_22683().method_4495()), (double)((float)(x + width) * (float)client.method_22683().method_4495()), (float)((float)y * (float)client.method_22683().method_4495()), (double)((float)(y + height) * (float)client.method_22683().method_4495()));
    }

    public static UUID[] addImmersivePortal(class_1937 world, double[] pos, double width, double height, class_2350.class_2351 axis, LinkDataComponent linkData, LinkTranslatorBlockEntity blockEntity) {
        if (axis == class_2350.class_2351.field_11052) {
            return null;
        }
        class_1799 stack = ModItems.WRITTEN_LINKING_BOOK.method_7854();
        LinkDataComponent itemData = (LinkDataComponent)ModComponents.ITEM_LINK_DATA.get((Object)stack);
        itemData.setDimension(linkData.getDimension());
        itemData.setLinkEffects(linkData.getLinkEffects());
        itemData.setPosition(linkData.getPosition());
        itemData.setRotation(linkData.getRotation());
        itemData.setUUID(linkData.getUUID());
        LinkingPortalEntity portal = new LinkingPortalEntity(linkingPortalEntityType, world, stack, blockEntity.method_11016());
        portal.method_23327(pos[0], pos[1], pos[2]);
        portal.setSquareShape(axis == class_2350.class_2351.field_11048 ? new class_243(1.0, 0.0, 0.0) : new class_243(0.0, 0.0, 1.0), new class_243(0.0, 1.0, 0.0), width, height);
        PortalManipulation.setPortalTransformation((Portal)portal, (class_5321)class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)linkData.getDimension()), (class_243)new class_243((double)linkData.getPosition().method_10263() + 0.5, (double)linkData.getPosition().method_10264() + height / 2.0, (double)linkData.getPosition().method_10260() + 0.5), null, (double)1.0);
        PortalManipulation.removeOverlappedPortals((class_1937)world, (class_243)portal.method_19538(), (class_243)portal.getNormal(), p -> p instanceof LinkingPortalEntity, p -> {});
        world.method_8649((class_1297)portal);
        LinkingPortalEntity reversePortal = (LinkingPortalEntity)PortalManipulation.createFlippedPortal((Portal)portal, linkingPortalEntityType);
        reversePortal.setBlockEntityPos(portal.getBlockEntityPos());
        PortalManipulation.removeOverlappedPortals((class_1937)world, (class_243)reversePortal.method_19538(), (class_243)reversePortal.getNormal(), p -> p instanceof LinkingPortalEntity, p -> {});
        world.method_8649((class_1297)reversePortal);
        return new UUID[]{portal.method_5667(), reversePortal.method_5667()};
    }

    public static void registerImmersivePortalsEntities() {
        linkingPortalEntityType = FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, LinkingPortalEntity::new).dimensions(new class_4048(1.0f, 1.0f, true)).fireImmune().trackRangeBlocks(96).forceTrackedVelocityUpdates(true).trackedUpdateRate(2).build();
        class_2378.method_10230((class_2378)class_2378.field_11145, (class_2960)Reference.EntityNames.LINKING_PORTAL, linkingPortalEntityType);
    }

    public static void registerEntityRenderingHandlers() {
        EntityRendererRegistry.INSTANCE.register(linkingPortalEntityType, (entityRenderDispatcher, context) -> new PortalEntityRenderer(entityRenderDispatcher));
    }

    public static List<LinkingPortalEntity> getNearbyLinkingPortals(class_2338 pos, class_1937 world) {
        return world.method_8390(LinkingPortalEntity.class, new class_238(pos.method_10087(64).method_10077(64).method_10088(64), pos.method_10086(64).method_10076(64).method_10089(64)), null);
    }

    public static void deleteLinkingPortals(LinkTranslatorBlockEntity blockEntity) {
        List<LinkingPortalEntity> nearbyPortals = ImmersivePortalsIntegration.getNearbyLinkingPortals(blockEntity.method_11016(), blockEntity.method_10997());
        for (LinkingPortalEntity portal : nearbyPortals) {
            if (!portal.getBlockEntityPos().equals((Object)blockEntity.method_11016())) continue;
            portal.method_5650();
        }
    }
}

