/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.util;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4970;
import net.minecraft.class_5454;
import net.minecraft.class_5459;
import org.jetbrains.annotations.Nullable;
import thefloydman.linkingbooks.api.component.LinkDataComponent;
import thefloydman.linkingbooks.block.LinkingPortalBlock;
import thefloydman.linkingbooks.block.ModBlocks;
import thefloydman.linkingbooks.world.LinkingBooksPersistentState;

public class LinkingPortalUtils {
    private static final class_4970.class_4973 IS_VALID_FRAME_BLOCK = (blockState, blockView, blockPos) -> blockState.method_27852(ModBlocks.NARA) || blockState.method_27852(ModBlocks.LINK_TRANSLATOR);
    private final class_1936 world;
    public final class_2350.class_2351 axis;
    private final class_2350 negativeDir;
    private int foundPortalBlocks;
    @Nullable
    public class_2338 lowerCorner;
    public int height;
    public int width;

    public static Optional<LinkingPortalUtils> canMakePortal(class_1936 worldAccess, class_2338 blockPos, class_2350.class_2351 axis) {
        return LinkingPortalUtils.canMakePortal(worldAccess, blockPos, linkingPortalUtil -> linkingPortalUtil.isValid() && linkingPortalUtil.foundPortalBlocks == 0, axis);
    }

    public static Optional<LinkingPortalUtils> canErasePortal(class_1936 worldAccess, class_2338 blockPos, class_2350.class_2351 axis) {
        return LinkingPortalUtils.canMakePortal(worldAccess, blockPos, linkingPortalUtil -> linkingPortalUtil.isValid() && linkingPortalUtil.foundPortalBlocks > 0, axis);
    }

    public static Optional<LinkingPortalUtils> canMakePortal(class_1936 worldAccess, class_2338 blockPos, Predicate<LinkingPortalUtils> predicate, class_2350.class_2351 axis) {
        Optional<LinkingPortalUtils> optional = Optional.of(new LinkingPortalUtils(worldAccess, blockPos, axis)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        class_2350.class_2351 axis2 = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        return Optional.of(new LinkingPortalUtils(worldAccess, blockPos, axis2)).filter(predicate);
    }

    public LinkingPortalUtils(class_1936 worldAccess, class_2338 blockPos, class_2350.class_2351 axis) {
        this.world = worldAccess;
        this.axis = axis;
        this.negativeDir = axis == class_2350.class_2351.field_11048 ? class_2350.field_11039 : class_2350.field_11035;
        this.lowerCorner = this.method_30492(blockPos);
        if (this.lowerCorner == null) {
            this.lowerCorner = blockPos;
            this.width = 1;
            this.height = 1;
        } else {
            this.width = this.method_30495();
            if (this.width > 0) {
                this.height = this.method_30496();
            }
        }
    }

    @Nullable
    private class_2338 method_30492(class_2338 blockPos) {
        int i = Math.max(0, blockPos.method_10264() - 21);
        while (blockPos.method_10264() > i && LinkingPortalUtils.validStateInsidePortal(this.world.method_8320(blockPos.method_10074()))) {
            blockPos = blockPos.method_10074();
        }
        class_2350 direction = this.negativeDir.method_10153();
        int j = this.method_30493(blockPos, direction) - 1;
        return j < 0 ? null : blockPos.method_10079(direction, j);
    }

    private int method_30495() {
        int i = this.method_30493(this.lowerCorner, this.negativeDir);
        return i >= 2 && i <= 21 ? i : 0;
    }

    private int method_30493(class_2338 blockPos, class_2350 direction) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int i = 0; i <= 21; ++i) {
            mutable.method_10101((class_2382)blockPos).method_10104(direction, i);
            class_2680 blockState = this.world.method_8320((class_2338)mutable);
            if (!LinkingPortalUtils.validStateInsidePortal(blockState)) {
                if (!IS_VALID_FRAME_BLOCK.test(blockState, (class_1922)this.world, (class_2338)mutable)) break;
                return i;
            }
            class_2680 blockState2 = this.world.method_8320((class_2338)mutable.method_10098(class_2350.field_11033));
            if (!IS_VALID_FRAME_BLOCK.test(blockState2, (class_1922)this.world, (class_2338)mutable)) break;
        }
        return 0;
    }

    private int method_30496() {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int i = this.method_30490(mutable);
        return i >= 3 && i <= 21 && this.method_30491(mutable, i) ? i : 0;
    }

    private boolean method_30491(class_2338.class_2339 mutable, int i) {
        for (int j = 0; j < this.width; ++j) {
            class_2338.class_2339 mutable2 = mutable.method_10101((class_2382)this.lowerCorner).method_10104(class_2350.field_11036, i).method_10104(this.negativeDir, j);
            if (IS_VALID_FRAME_BLOCK.test(this.world.method_8320((class_2338)mutable2), (class_1922)this.world, (class_2338)mutable2)) continue;
            return false;
        }
        return true;
    }

    private int method_30490(class_2338.class_2339 mutable) {
        for (int i = 0; i < 21; ++i) {
            mutable.method_10101((class_2382)this.lowerCorner).method_10104(class_2350.field_11036, i).method_10104(this.negativeDir, -1);
            if (!IS_VALID_FRAME_BLOCK.test(this.world.method_8320((class_2338)mutable), (class_1922)this.world, (class_2338)mutable)) {
                return i;
            }
            mutable.method_10101((class_2382)this.lowerCorner).method_10104(class_2350.field_11036, i).method_10104(this.negativeDir, this.width);
            if (!IS_VALID_FRAME_BLOCK.test(this.world.method_8320((class_2338)mutable), (class_1922)this.world, (class_2338)mutable)) {
                return i;
            }
            for (int j = 0; j < this.width; ++j) {
                mutable.method_10101((class_2382)this.lowerCorner).method_10104(class_2350.field_11036, i).method_10104(this.negativeDir, j);
                class_2680 blockState = this.world.method_8320((class_2338)mutable);
                if (!LinkingPortalUtils.validStateInsidePortal(blockState)) {
                    return i;
                }
                if (!blockState.method_27852(ModBlocks.LINKING_PORTAL)) continue;
                ++this.foundPortalBlocks;
            }
        }
        return 21;
    }

    private static boolean validStateInsidePortal(class_2680 blockState) {
        return blockState.method_26215() || blockState.method_26164((class_3494)class_3481.field_21952) || blockState.method_27852(ModBlocks.LINKING_PORTAL);
    }

    public boolean isValid() {
        return this.lowerCorner != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void createPortal(LinkDataComponent linkData) {
        class_2680 blockState = (class_2680)ModBlocks.LINKING_PORTAL.method_9564().method_11657(LinkingPortalBlock.AXIS, (Comparable)this.axis);
        class_2338.method_10097((class_2338)this.lowerCorner, (class_2338)this.lowerCorner.method_10079(class_2350.field_11036, this.height - 1).method_10079(this.negativeDir, this.width - 1)).forEach(blockPos -> {
            this.world.method_8652(blockPos, blockState, 18);
            if (this.world instanceof class_3218) {
                LinkingBooksPersistentState persistentState = (LinkingBooksPersistentState)((class_3218)this.world).method_17983().method_17924(LinkingBooksPersistentState::new, "linkingbooks");
                persistentState.addLinkingPortalData((class_2338)blockPos, linkData);
            }
        });
    }

    public void erasePortal() {
        class_2680 blockState = class_2246.field_10124.method_9564();
        class_2338.method_10097((class_2338)this.lowerCorner, (class_2338)this.lowerCorner.method_10079(class_2350.field_11036, this.height - 1).method_10079(this.negativeDir, this.width - 1)).forEach(blockPos -> {
            this.world.method_8652(blockPos, blockState, 18);
            if (this.world instanceof class_3218) {
                LinkingBooksPersistentState persistentState = (LinkingBooksPersistentState)((class_3218)this.world).method_17983().method_17924(LinkingBooksPersistentState::new, "linkingbooks");
                persistentState.removeLinkingPortalData((class_2338)blockPos);
            }
        });
    }

    public boolean wasAlreadyValid() {
        return this.isValid() && this.foundPortalBlocks == this.width * this.height;
    }

    public static class_243 method_30494(class_5459.class_5460 arg, class_2350.class_2351 axis, class_243 vec3d, class_4048 entityDimensions) {
        double j;
        class_2350.class_2351 axis3;
        double h;
        double d = (double)arg.field_25937 - (double)entityDimensions.field_18067;
        double e = (double)arg.field_25938 - (double)entityDimensions.field_18068;
        class_2338 blockPos = arg.field_25936;
        if (d > 0.0) {
            float f = (float)blockPos.method_30558(axis) + entityDimensions.field_18067 / 2.0f;
            h = class_3532.method_15350((double)class_3532.method_15370((double)(vec3d.method_18043(axis) - (double)f), (double)0.0, (double)d), (double)0.0, (double)1.0);
        } else {
            h = 0.5;
        }
        if (e > 0.0) {
            axis3 = class_2350.class_2351.field_11052;
            j = class_3532.method_15350((double)class_3532.method_15370((double)(vec3d.method_18043(axis3) - (double)blockPos.method_30558(axis3)), (double)0.0, (double)e), (double)0.0, (double)1.0);
        } else {
            j = 0.0;
        }
        axis3 = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        double k = vec3d.method_18043(axis3) - ((double)blockPos.method_30558(axis3) + 0.5);
        return new class_243(h, j, k);
    }

    public static class_5454 method_30484(class_3218 serverWorld, class_5459.class_5460 arg, class_2350.class_2351 axis, class_243 vec3d, class_4048 entityDimensions, class_243 vec3d2, float f, float g) {
        class_2338 blockPos = arg.field_25936;
        class_2680 blockState = serverWorld.method_8320(blockPos);
        class_2350.class_2351 axis2 = (class_2350.class_2351)blockState.method_11654((class_2769)class_2741.field_12529);
        double d = arg.field_25937;
        double e = arg.field_25938;
        int i = axis == axis2 ? 0 : 90;
        class_243 vec3d3 = axis == axis2 ? vec3d2 : new class_243(vec3d2.field_1350, vec3d2.field_1351, -vec3d2.field_1352);
        double h = (double)entityDimensions.field_18067 / 2.0 + (d - (double)entityDimensions.field_18067) * vec3d.method_10216();
        double j = (e - (double)entityDimensions.field_18068) * vec3d.method_10214();
        double k = 0.5 + vec3d.method_10215();
        boolean bl = axis2 == class_2350.class_2351.field_11048;
        class_243 vec3d4 = new class_243((double)blockPos.method_10263() + (bl ? h : k), (double)blockPos.method_10264() + j, (double)blockPos.method_10260() + (bl ? k : h));
        return new class_5454(vec3d4, vec3d3, f + (float)i, g);
    }
}

