/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ModConfig COMMON;
    public final ForgeConfigSpec.IntValue linkingCostExperienceLevels;
    public final ForgeConfigSpec.IntValue linkingPanelChunkLoadRadius;
    public final ForgeConfigSpec.IntValue linkingPanelChunkRenderDistance;
    public final ForgeConfigSpec.BooleanValue useImmersivePortalsForLinkingPortals;

    ModConfig(ForgeConfigSpec.Builder builder) {
        this.linkingCostExperienceLevels = builder.comment("How many experience levels it costs to use a linking book. Stacks with points option.").translation("linkingbooks.configgui.linkingcost_levels").defineInRange("linkingCostLevels", 0, 0, Integer.MAX_VALUE);
        this.linkingPanelChunkLoadRadius = builder.comment("The radius of chunks to load when a linking panel is rendering.").translation("linkingbooks.configgui.panel_chunk_load_radius").defineInRange("linkingPanelChunkLoadRadius", 4, 0, Integer.MAX_VALUE);
        this.linkingPanelChunkRenderDistance = builder.comment("The maximum render distance (in chunks) of a linking panel.").translation("linkingbooks.configgui.panel_chunk_render_distance").defineInRange("linkingPanelChunkRenderDistance", 4, 0, Integer.MAX_VALUE);
        this.useImmersivePortalsForLinkingPortals = builder.comment("If Immersive Portals is present, uses it to render Linking Portals.").translation("linkingbooks.configgui.use_immersive_portals_for_linking_portals").define("useImmersivePortalsForLinkingPortals", true);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ModConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (ModConfig)specPair.getLeft();
    }
}

