/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.network.packets;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import thefloydman.linkingbooks.api.capability.ILinkData;
import thefloydman.linkingbooks.capability.LinkData;
import thefloydman.linkingbooks.network.packets.IMessage;
import thefloydman.linkingbooks.util.LinkingUtils;

public class LinkMessage
implements IMessage {
    public boolean holdingBook = false;
    public ILinkData linkData = (ILinkData)LinkData.LINK_DATA.getDefaultInstance();

    public LinkMessage(boolean holdingBook, ILinkData linkData) {
        this.holdingBook = holdingBook;
        this.linkData = linkData;
    }

    public LinkMessage() {
        this(false, (ILinkData)LinkData.LINK_DATA.getDefaultInstance());
    }

    @Override
    public PacketBuffer toData(PacketBuffer buffer) {
        buffer.writeBoolean(this.holdingBook);
        this.linkData.write(buffer);
        return buffer;
    }

    @Override
    public void fromData(PacketBuffer buffer) {
        this.holdingBook = buffer.readBoolean();
        this.linkData.read(buffer);
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            LinkingUtils.linkEntity((Entity)player, this.linkData, this.holdingBook);
            ctx.setPacketHandled(true);
        });
    }
}

