/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.util;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.EntitySize;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import thefloydman.linkingbooks.api.capability.ILinkData;
import thefloydman.linkingbooks.block.LinkingPortalBlock;
import thefloydman.linkingbooks.block.ModBlocks;
import thefloydman.linkingbooks.world.storage.LinkingBooksSavedData;

public class LinkingPortalUtils {
    private static final AbstractBlock.IPositionPredicate IS_VALID_FRAME_BLOCK = (blockState, blockView, blockPos) -> blockState.func_203425_a((Block)ModBlocks.NARA.get()) || blockState.func_203425_a((Block)ModBlocks.LINK_TRANSLATOR.get());
    private final IWorld world;
    public final Direction.Axis axis;
    private final Direction negativeDir;
    private int foundPortalBlocks;
    @Nullable
    public BlockPos lowerCorner;
    public int height;
    public int width;

    public static Optional<LinkingPortalUtils> canMakePortal(IWorld worldAccess, BlockPos blockPos, Direction.Axis axis) {
        return LinkingPortalUtils.canMakePortal(worldAccess, blockPos, linkingPortalUtil -> linkingPortalUtil.isValid() && linkingPortalUtil.foundPortalBlocks == 0, axis);
    }

    public static Optional<LinkingPortalUtils> canErasePortal(IWorld worldAccess, BlockPos blockPos, Direction.Axis axis) {
        return LinkingPortalUtils.canMakePortal(worldAccess, blockPos, linkingPortalUtil -> linkingPortalUtil.isValid() && linkingPortalUtil.foundPortalBlocks > 0, axis);
    }

    public static Optional<LinkingPortalUtils> canMakePortal(IWorld worldAccess, BlockPos blockPos, Predicate<LinkingPortalUtils> predicate, Direction.Axis axis) {
        Optional<LinkingPortalUtils> optional = Optional.of(new LinkingPortalUtils(worldAccess, blockPos, axis)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        Direction.Axis axis2 = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return Optional.of(new LinkingPortalUtils(worldAccess, blockPos, axis2)).filter(predicate);
    }

    public LinkingPortalUtils(IWorld worldAccess, BlockPos blockPos, Direction.Axis axis) {
        this.world = worldAccess;
        this.axis = axis;
        this.negativeDir = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        this.lowerCorner = this.method_30492(blockPos);
        if (this.lowerCorner == null) {
            this.lowerCorner = blockPos;
            this.width = 1;
            this.height = 1;
        } else {
            this.width = this.method_30495();
            if (this.width > 0) {
                this.height = this.method_30496();
            }
        }
    }

    @Nullable
    private BlockPos method_30492(BlockPos blockPos) {
        int i = Math.max(0, blockPos.func_177956_o() - 21);
        while (blockPos.func_177956_o() > i && LinkingPortalUtils.validStateInsidePortal(this.world.func_180495_p(blockPos.func_177977_b()))) {
            blockPos = blockPos.func_177977_b();
        }
        Direction direction = this.negativeDir.func_176734_d();
        int j = this.method_30493(blockPos, direction) - 1;
        return j < 0 ? null : blockPos.func_177967_a(direction, j);
    }

    private int method_30495() {
        int i = this.method_30493(this.lowerCorner, this.negativeDir);
        return i >= 2 && i <= 21 ? i : 0;
    }

    private int method_30493(BlockPos blockPos, Direction direction) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int i = 0; i <= 21; ++i) {
            mutable.func_189533_g((Vector3i)blockPos).func_189534_c(direction, i);
            BlockState blockState = this.world.func_180495_p((BlockPos)mutable);
            if (!LinkingPortalUtils.validStateInsidePortal(blockState)) {
                if (!IS_VALID_FRAME_BLOCK.test(blockState, (IBlockReader)this.world, (BlockPos)mutable)) break;
                return i;
            }
            BlockState blockState2 = this.world.func_180495_p((BlockPos)mutable.func_189536_c(Direction.DOWN));
            if (!IS_VALID_FRAME_BLOCK.test(blockState2, (IBlockReader)this.world, (BlockPos)mutable)) break;
        }
        return 0;
    }

    private int method_30496() {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int i = this.method_30490(mutable);
        return i >= 3 && i <= 21 && this.method_30491(mutable, i) ? i : 0;
    }

    private boolean method_30491(BlockPos.Mutable mutable, int i) {
        for (int j = 0; j < this.width; ++j) {
            BlockPos.Mutable mutable2 = mutable.func_189533_g((Vector3i)this.lowerCorner).func_189534_c(Direction.UP, i).func_189534_c(this.negativeDir, j);
            if (IS_VALID_FRAME_BLOCK.test(this.world.func_180495_p((BlockPos)mutable2), (IBlockReader)this.world, (BlockPos)mutable2)) continue;
            return false;
        }
        return true;
    }

    private int method_30490(BlockPos.Mutable mutable) {
        for (int i = 0; i < 21; ++i) {
            mutable.func_189533_g((Vector3i)this.lowerCorner).func_189534_c(Direction.UP, i).func_189534_c(this.negativeDir, -1);
            if (!IS_VALID_FRAME_BLOCK.test(this.world.func_180495_p((BlockPos)mutable), (IBlockReader)this.world, (BlockPos)mutable)) {
                return i;
            }
            mutable.func_189533_g((Vector3i)this.lowerCorner).func_189534_c(Direction.UP, i).func_189534_c(this.negativeDir, this.width);
            if (!IS_VALID_FRAME_BLOCK.test(this.world.func_180495_p((BlockPos)mutable), (IBlockReader)this.world, (BlockPos)mutable)) {
                return i;
            }
            for (int j = 0; j < this.width; ++j) {
                mutable.func_189533_g((Vector3i)this.lowerCorner).func_189534_c(Direction.UP, i).func_189534_c(this.negativeDir, j);
                BlockState blockState = this.world.func_180495_p((BlockPos)mutable);
                if (!LinkingPortalUtils.validStateInsidePortal(blockState)) {
                    return i;
                }
                if (!blockState.func_203425_a((Block)ModBlocks.LINKING_PORTAL.get())) continue;
                ++this.foundPortalBlocks;
            }
        }
        return 21;
    }

    private static boolean validStateInsidePortal(BlockState blockState) {
        return blockState.func_196958_f() || blockState.func_235714_a_((ITag)BlockTags.field_232872_am_) || blockState.func_203425_a((Block)ModBlocks.LINKING_PORTAL.get());
    }

    public boolean isValid() {
        return this.lowerCorner != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void createPortal(ILinkData linkData) {
        BlockState blockState = (BlockState)((Block)ModBlocks.LINKING_PORTAL.get()).func_176223_P().func_206870_a(LinkingPortalBlock.AXIS, (Comparable)this.axis);
        BlockPos.func_218278_a((BlockPos)this.lowerCorner, (BlockPos)this.lowerCorner.func_177967_a(Direction.UP, this.height - 1).func_177967_a(this.negativeDir, this.width - 1)).forEach(blockPos -> {
            this.world.func_180501_a(blockPos, blockState, 18);
            if (this.world instanceof ServerWorld) {
                LinkingBooksSavedData persistentState = (LinkingBooksSavedData)((ServerWorld)this.world).func_217481_x().func_215752_a(LinkingBooksSavedData::new, "linkingbooks");
                persistentState.addLinkingPortalData((BlockPos)blockPos, linkData);
            }
        });
    }

    public void erasePortal() {
        BlockState blockState = Blocks.field_150350_a.func_176223_P();
        BlockPos.func_218278_a((BlockPos)this.lowerCorner, (BlockPos)this.lowerCorner.func_177967_a(Direction.UP, this.height - 1).func_177967_a(this.negativeDir, this.width - 1)).forEach(blockPos -> {
            this.world.func_180501_a(blockPos, blockState, 18);
            if (this.world instanceof ServerWorld) {
                LinkingBooksSavedData persistentState = (LinkingBooksSavedData)((ServerWorld)this.world).func_217481_x().func_215752_a(LinkingBooksSavedData::new, "linkingbooks");
                persistentState.removeLinkingPortalData((BlockPos)blockPos);
            }
        });
    }

    public boolean wasAlreadyValid() {
        return this.isValid() && this.foundPortalBlocks == this.width * this.height;
    }

    public static Vector3d method_30494(TeleportationRepositioner.Result arg, Direction.Axis axis, Vector3d vec3d, EntitySize entityDimensions) {
        double j;
        Direction.Axis axis3;
        double h;
        double d = (double)arg.field_243680_b - (double)entityDimensions.field_220315_a;
        double e = (double)arg.field_243681_c - (double)entityDimensions.field_220316_b;
        BlockPos blockPos = arg.field_243679_a;
        if (d > 0.0) {
            float f = (float)blockPos.func_243648_a(axis) + entityDimensions.field_220315_a / 2.0f;
            h = MathHelper.func_151237_a((double)MathHelper.func_233020_c_((double)(vec3d.func_216370_a(axis) - (double)f), (double)0.0, (double)d), (double)0.0, (double)1.0);
        } else {
            h = 0.5;
        }
        if (e > 0.0) {
            axis3 = Direction.Axis.Y;
            j = MathHelper.func_151237_a((double)MathHelper.func_233020_c_((double)(vec3d.func_216370_a(axis3) - (double)blockPos.func_243648_a(axis3)), (double)0.0, (double)e), (double)0.0, (double)1.0);
        } else {
            j = 0.0;
        }
        axis3 = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        double k = vec3d.func_216370_a(axis3) - ((double)blockPos.func_243648_a(axis3) + 0.5);
        return new Vector3d(h, j, k);
    }

    public static PortalInfo method_30484(ServerWorld serverWorld, TeleportationRepositioner.Result arg, Direction.Axis axis, Vector3d vec3d, EntitySize entityDimensions, Vector3d vec3d2, float f, float g) {
        BlockPos blockPos = arg.field_243679_a;
        BlockState blockState = serverWorld.func_180495_p(blockPos);
        Direction.Axis axis2 = (Direction.Axis)blockState.func_177229_b((Property)BlockStateProperties.field_208199_z);
        double d = arg.field_243680_b;
        double e = arg.field_243681_c;
        int i = axis == axis2 ? 0 : 90;
        Vector3d vec3d3 = axis == axis2 ? vec3d2 : new Vector3d(vec3d2.field_72449_c, vec3d2.field_72448_b, -vec3d2.field_72450_a);
        double h = (double)entityDimensions.field_220315_a / 2.0 + (d - (double)entityDimensions.field_220315_a) * vec3d.func_82615_a();
        double j = (e - (double)entityDimensions.field_220316_b) * vec3d.func_82617_b();
        double k = 0.5 + vec3d.func_82616_c();
        boolean bl = axis2 == Direction.Axis.X;
        Vector3d vec3d4 = new Vector3d((double)blockPos.func_177958_n() + (bl ? h : k), (double)blockPos.func_177956_o() + j, (double)blockPos.func_177952_p() + (bl ? k : h));
        return new PortalInfo(vec3d4, vec3d3, f + (float)i, g);
    }
}

