/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import thefloydman.linkingbooks.tileentity.MarkerSwitchTileEntity;
import thefloydman.linkingbooks.tileentity.ModTileEntityTypes;

public class MarkerSwitchBlock
extends HorizontalBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final VoxelShape SHAPE_BOTTOM;
    public static final VoxelShape SHAPE_TOP;
    public static final EnumProperty<DoubleBlockHalf> HALF;

    protected MarkerSwitchBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPE_BOTTOM;
        }
        return SHAPE_TOP;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPE_BOTTOM;
        }
        return SHAPE_TOP;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPE_BOTTOM;
        }
        return SHAPE_TOP;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, POWERED, HALF, OPEN});
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!world.func_201670_d() && !player.func_225608_bj_()) {
            state = (BlockState)state.func_235896_a_((Property)POWERED);
            world.func_180501_a(pos, state, 10);
            world.func_195593_d(pos, (Block)this);
            world.func_195593_d(pos.func_177972_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d()), (Block)this);
            world.func_195593_d(pos.func_177972_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176735_f().func_176734_d()), (Block)this);
            BlockPos otherPos = state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? pos.func_177977_b() : pos.func_177984_a();
            world.func_195593_d(otherPos, (Block)this);
            world.func_195593_d(otherPos.func_177972_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d()), (Block)this);
            world.func_195593_d(otherPos.func_177972_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176735_f().func_176734_d()), (Block)this);
            world.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.5f, 0.5f);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        BlockPos otherPos = state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? pos.func_177977_b() : pos.func_177984_a();
        BlockState otherState = world.func_180495_p(otherPos);
        if (otherState.func_177230_c() == this) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, otherState.func_177229_b((Property)POWERED)));
            if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER && world.func_175651_c(pos.func_177977_b(), Direction.DOWN) > 0 || state.func_177229_b(HALF) == DoubleBlockHalf.UPPER && world.func_175651_c(otherPos.func_177977_b(), Direction.DOWN) > 0) {
                boolean changed = (Boolean)state.func_177229_b((Property)OPEN) == false;
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(true)), 10);
                world.func_180501_a(otherPos, (BlockState)otherState.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(true)), 10);
                if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER && changed) {
                    world.func_184133_a(null, pos, SoundEvents.field_187879_gP, SoundCategory.BLOCKS, 0.5f, 0.5f);
                }
            } else {
                boolean changed = (Boolean)state.func_177229_b((Property)OPEN) == true;
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false)), 10);
                world.func_180501_a(otherPos, (BlockState)otherState.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false)), 10);
                if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER && changed) {
                    world.func_184133_a(null, pos, SoundEvents.field_187877_gO, SoundCategory.BLOCKS, 0.5f, 0.5f);
                }
            }
        }
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (direction.func_176740_k() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return newState.func_203425_a((Block)this) && newState.func_177229_b(HALF) != doubleBlockHalf ? (BlockState)((BlockState)state.func_206870_a((Property)field_185512_D, newState.func_177229_b((Property)field_185512_D))).func_206870_a((Property)POWERED, newState.func_177229_b((Property)POWERED)) : Blocks.field_150350_a.func_176223_P();
        }
        return doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.func_196955_c((IWorldReader)world, pos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, direction, newState, world, pos, posFrom);
    }

    public int func_180656_a(BlockState state, IBlockReader blockAccess, BlockPos pos, Direction direction) {
        return direction != Direction.UP && direction != Direction.DOWN && (direction == state.func_177229_b((Property)field_185512_D) || direction == ((Direction)state.func_177229_b((Property)field_185512_D)).func_176735_f()) && (Boolean)state.func_177229_b((Property)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(BlockState state, IBlockReader blockAccess, BlockPos pos, Direction direction) {
        return (Boolean)state.func_177229_b((Property)POWERED) != false && (direction == state.func_177229_b((Property)field_185512_D) || direction == ((Direction)state.func_177229_b((Property)field_185512_D)).func_176735_f()) ? 15 : 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf;
        if (!world.func_201670_d() && player.func_184812_l_() && (doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF)) == DoubleBlockHalf.UPPER && (blockstate = world.func_180495_p(blockpos = pos.func_177977_b())).func_177230_c() == state.func_177230_c() && blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
        super.func_176208_a(world, pos, state, player);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.MARKER_SWITCH.get()).func_200968_a();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity;
        if (state.func_177230_c() != newState.func_177230_c() && state.func_177229_b(HALF) == DoubleBlockHalf.LOWER && !world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof MarkerSwitchTileEntity) {
            MarkerSwitchTileEntity markerTE = (MarkerSwitchTileEntity)tileEntity;
            if (markerTE.hasItem()) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)markerTE);
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    static {
        HALF = BlockStateProperties.field_208163_P;
        VoxelShape bottom = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        VoxelShape top = Block.func_208617_a((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        SHAPE_BOTTOM = VoxelShapes.func_197872_a((VoxelShape)bottom, (VoxelShape)top);
        SHAPE_TOP = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    }
}

