/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.block;

import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import thefloydman.linkingbooks.api.capability.ILinkData;
import thefloydman.linkingbooks.capability.LinkData;
import thefloydman.linkingbooks.config.ModConfig;
import thefloydman.linkingbooks.integration.ImmersivePortalsIntegration;
import thefloydman.linkingbooks.linking.LinkEffects;
import thefloydman.linkingbooks.tileentity.LinkTranslatorTileEntity;
import thefloydman.linkingbooks.util.LinkingPortalUtils;
import thefloydman.linkingbooks.util.Reference;

public class NaraBlock
extends Block {
    public NaraBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        super.func_180633_a(world, blockPos, blockState, livingEntity, itemStack);
        for (int x = blockPos.func_177958_n() - 32; x < blockPos.func_177958_n() + 32; ++x) {
            for (int y = blockPos.func_177956_o() - 32; y < blockPos.func_177956_o() + 32; ++y) {
                for (int z = blockPos.func_177952_p() - 32; z < blockPos.func_177952_p() + 32; ++z) {
                    LinkTranslatorTileEntity translator;
                    BlockPos currentPos = new BlockPos(x, y, z);
                    TileEntity blockEntity = world.func_175625_s(currentPos);
                    if (blockEntity == null || !(blockEntity instanceof LinkTranslatorTileEntity) || !(translator = (LinkTranslatorTileEntity)blockEntity).hasBook()) continue;
                    ILinkData linkData = (ILinkData)translator.getBook().getCapability(LinkData.LINK_DATA).orElse(null);
                    this.tryMakePortalInDirection(world, currentPos, Direction.NORTH, linkData, translator);
                    this.tryMakePortalInDirection(world, currentPos, Direction.EAST, linkData, translator);
                    this.tryMakePortalInDirection(world, currentPos, Direction.SOUTH, linkData, translator);
                    this.tryMakePortalInDirection(world, currentPos, Direction.WEST, linkData, translator);
                }
            }
        }
    }

    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.func_203425_a(blockState2.func_177230_c())) {
            for (int x = blockPos.func_177958_n() - 32; x < blockPos.func_177958_n() + 32; ++x) {
                for (int y = blockPos.func_177956_o() - 32; y < blockPos.func_177956_o() + 32; ++y) {
                    for (int z = blockPos.func_177952_p() - 32; z < blockPos.func_177952_p() + 32; ++z) {
                        boolean deletePortal;
                        BlockPos currentPos = new BlockPos(x, y, z);
                        TileEntity blockEntity = world.func_175625_s(currentPos);
                        if (blockEntity == null || !(blockEntity instanceof LinkTranslatorTileEntity)) continue;
                        LinkTranslatorTileEntity translator = (LinkTranslatorTileEntity)blockEntity;
                        boolean bl2 = deletePortal = !this.canPortalExistInDirection(world, currentPos, Direction.NORTH) && !this.canPortalExistInDirection(world, currentPos, Direction.EAST) && !this.canPortalExistInDirection(world, currentPos, Direction.SOUTH) && !this.canPortalExistInDirection(world, currentPos, Direction.WEST);
                        if (!deletePortal || !Reference.isImmersivePortalsLoaded()) continue;
                        ImmersivePortalsIntegration.deleteLinkingPortals(translator);
                    }
                }
            }
        }
        super.func_196243_a(blockState, world, blockPos, blockState2, bl);
    }

    private boolean canPortalExistInDirection(World world, BlockPos pos, Direction direction) {
        Optional<LinkingPortalUtils> optional = LinkingPortalUtils.canMakePortal((IWorld)world, pos.func_177972_a(direction), Direction.Axis.X);
        return optional.isPresent();
    }

    private void tryMakePortalInDirection(World world, BlockPos pos, Direction direction, ILinkData linkData, LinkTranslatorTileEntity blockEntity) {
        if (world.func_234923_W_().func_240901_a_().equals((Object)linkData.getDimension()) && !linkData.getLinkEffects().contains(LinkEffects.INTRAAGE_LINKING.get())) {
            return;
        }
        Optional<LinkingPortalUtils> optional = LinkingPortalUtils.canMakePortal((IWorld)world, pos.func_177972_a(direction), Direction.Axis.X);
        if (optional.isPresent()) {
            LinkingPortalUtils util = optional.get();
            if (Reference.isImmersivePortalsLoaded() && ((Boolean)ModConfig.COMMON.useImmersivePortalsForLinkingPortals.get()).booleanValue()) {
                double x = util.axis == Direction.Axis.X ? (double)util.lowerCorner.func_177958_n() + (double)util.width / 2.0 - ((double)util.width - 1.0) : (double)util.lowerCorner.func_177958_n() + 0.5;
                double y = (double)util.lowerCorner.func_177956_o() + (double)util.height / 2.0;
                double z = util.axis == Direction.Axis.X ? (double)util.lowerCorner.func_177952_p() + 0.5 : (double)util.lowerCorner.func_177952_p() + (double)util.width / 2.0;
                ImmersivePortalsIntegration.addImmersivePortal(world, new double[]{x, y, z}, util.width, util.height, util.axis, linkData, blockEntity);
            } else {
                util.createPortal(linkData);
            }
        }
    }
}

