/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.entity;

import com.qouteall.immersive_portals.portal.Portal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thefloydman.linkingbooks.api.capability.ILinkData;
import thefloydman.linkingbooks.api.linking.LinkEffect;
import thefloydman.linkingbooks.capability.LinkData;
import thefloydman.linkingbooks.config.ModConfig;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;
import thefloydman.linkingbooks.linking.LinkEffects;

public class LinkingPortalEntity
extends Portal {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(LinkingPortalEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<BlockPos> TILEENTITY_POS = EntityDataManager.func_187226_a(LinkingPortalEntity.class, (IDataSerializer)DataSerializers.field_187200_j);

    public LinkingPortalEntity(EntityType<?> entityType, World world, ItemStack book, BlockPos tileEntityPos) {
        super(entityType, world);
        this.field_70180_af.func_187227_b(ITEM, (Object)(book == null ? ItemStack.field_190927_a : book));
        this.field_70180_af.func_187227_b(TILEENTITY_POS, (Object)(tileEntityPos == null ? BlockPos.field_177992_a : tileEntityPos));
    }

    public LinkingPortalEntity(EntityType<?> entityType, World world) {
        this(entityType, world, ItemStack.field_190927_a, BlockPos.field_177992_a);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(TILEENTITY_POS, (Object)BlockPos.field_177992_a);
    }

    public BlockPos getTileEntityPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(TILEENTITY_POS);
    }

    public void setTileEntityPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(TILEENTITY_POS, (Object)pos);
    }

    public void onEntityTeleportedOnServer(Entity entity) {
        super.onEntityTeleportedOnServer(entity);
        if (!((ItemStack)this.field_70180_af.func_187225_a(ITEM)).func_190926_b()) {
            ILinkData linkData = (ILinkData)((ItemStack)this.field_70180_af.func_187225_a(ITEM)).getCapability(LinkData.LINK_DATA).orElse(null);
            for (LinkEffect effect : linkData.getLinkEffects()) {
                effect.onLinkStart(entity, linkData);
                effect.onLinkEnd(entity, linkData);
            }
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.func_82242_a((Integer)ModConfig.COMMON.linkingCostExperienceLevels.get() * -1);
        }
    }

    public boolean canTeleportEntity(Entity entity) {
        boolean ip = super.canTeleportEntity(entity);
        boolean lb = true;
        if (!((ItemStack)this.field_70180_af.func_187225_a(ITEM)).func_190926_b()) {
            ILinkData linkData = (ILinkData)((ItemStack)this.field_70180_af.func_187225_a(ITEM)).getCapability(LinkData.LINK_DATA).orElse(null);
            if (this.getDestWorld() == this.getOriginWorld() && !linkData.getLinkEffects().contains(LinkEffects.INTRAAGE_LINKING.get())) {
                lb = false;
            } else if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                lb = player.field_71068_ca >= (Integer)ModConfig.COMMON.linkingCostExperienceLevels.get();
            }
        }
        return ip && lb;
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("book", 10)) {
            ItemStack book = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("book"));
            if (book.func_77973_b() instanceof WrittenLinkingBookItem) {
                this.field_70180_af.func_187227_b(ITEM, (Object)book);
            } else {
                this.field_70180_af.func_187227_b(ITEM, (Object)ItemStack.field_190927_a);
            }
        }
        if (compound.func_150297_b("tileentity_pos", 10)) {
            this.setTileEntityPos(NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("tileentity_pos")));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ItemStack item = (ItemStack)this.field_70180_af.func_187225_a(ITEM);
        if (!item.func_190926_b()) {
            compound.func_218657_a("book", (INBT)item.func_77955_b(new CompoundNBT()));
        }
        compound.func_218657_a("tileentity_pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getTileEntityPos()));
    }
}

