/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ObjectEntity
extends Entity {
    private static final DataParameter<Float> DURABILITY = EntityDataManager.func_187226_a(ObjectEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(ObjectEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final String LABEL_DURABILITY = "Durability";
    private static final String LABEL_ITEM = "Item";
    private static final String LABEL_HURTTIME = "HurtTime";
    private final Class<? extends Item> itemClass;
    private final float maxDurability;
    public int hurtTime;

    public ObjectEntity(EntityType<? extends ObjectEntity> type, World world, Class<? extends Item> itemClass, float maxDurability) {
        super(type, world);
        this.itemClass = itemClass;
        this.maxDurability = maxDurability;
        this.setDurability(this.getMaxDurability());
        this.hurtTime = 0;
    }

    public ObjectEntity(EntityType<? extends ObjectEntity> type, World world, Class<? extends Item> itemClass, float maxDurability, ItemStack item) {
        this(type, world, itemClass, maxDurability);
        this.setItem(item);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DURABILITY, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b(LABEL_DURABILITY, 99)) {
            this.setDurability(compound.func_74760_g(LABEL_DURABILITY));
        }
        if (compound.func_150297_b(LABEL_ITEM, 10)) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l(LABEL_ITEM));
            if (this.itemClass.isInstance(stack.func_77973_b())) {
                this.setItem(stack);
            } else {
                this.setItem(ItemStack.field_190927_a);
            }
        }
        this.hurtTime = compound.func_74765_d(LABEL_HURTTIME);
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a(LABEL_DURABILITY, this.getDurability());
        compound.func_218657_a(LABEL_ITEM, (INBT)this.getItem().serializeNBT());
        compound.func_74777_a(LABEL_HURTTIME, (short)this.hurtTime);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public final float getMaxDurability() {
        return this.maxDurability;
    }

    public float getDurability() {
        return ((Float)this.field_70180_af.func_187225_a(DURABILITY)).floatValue();
    }

    public void setDurability(float health) {
        this.field_70180_af.func_187227_b(DURABILITY, (Object)Float.valueOf(MathHelper.func_76131_a((float)health, (float)0.0f, (float)this.getMaxDurability())));
    }

    public ItemStack getItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(ITEM);
    }

    public void setItem(ItemStack item) {
        this.field_70180_af.func_187227_b(ITEM, (Object)item);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.hurtTime = 10;
        this.setDurability(this.getDurability() - amount);
        return super.func_70097_a(source, amount);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.getItem().func_190926_b() || this.getDurability() <= 0.0f) {
            this.onKilled();
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        Vector3d vec3d = this.func_213322_ci();
        double d1 = vec3d.field_72450_a;
        double d3 = vec3d.field_72448_b;
        double d5 = vec3d.field_72449_c;
        if (this.field_70122_E) {
            d1 *= 0.8;
            d5 *= 0.8;
        }
        if (Math.abs(vec3d.field_72450_a) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vec3d.field_72448_b) < 0.003) {
            d3 = 0.0;
        }
        if (Math.abs(vec3d.field_72449_c) < 0.003) {
            d5 = 0.0;
        }
        this.func_213293_j(d1, d3, d5);
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public void onKilled() {
        this.func_174812_G();
    }

    public void func_70100_b_(PlayerEntity player) {
        if ((double)this.func_70032_d((Entity)player) < 0.75) {
            player.func_70108_f((Entity)this);
        }
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public boolean func_70104_M() {
        return this.func_70089_S();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 256.0 * ObjectEntity.func_184183_bd()) * d0;
    }
}

