/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.integration;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.qouteall.immersive_portals.ClientWorldLoader;
import com.qouteall.immersive_portals.chunk_loading.ChunkVisibilityManager;
import com.qouteall.immersive_portals.chunk_loading.DimensionalChunkPos;
import com.qouteall.immersive_portals.chunk_loading.NewChunkTrackingGraph;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.PortalManipulation;
import com.qouteall.immersive_portals.render.GuiPortalRendering;
import com.qouteall.immersive_portals.render.MyRenderHelper;
import com.qouteall.immersive_portals.render.PortalEntityRenderer;
import com.qouteall.immersive_portals.render.context_management.WorldRenderInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import thefloydman.linkingbooks.api.capability.ILinkData;
import thefloydman.linkingbooks.capability.LinkData;
import thefloydman.linkingbooks.config.ModConfig;
import thefloydman.linkingbooks.entity.LinkingPortalEntity;
import thefloydman.linkingbooks.item.ModItems;
import thefloydman.linkingbooks.tileentity.LinkTranslatorTileEntity;
import thefloydman.linkingbooks.util.Reference;

public class ImmersivePortalsIntegration {
    private static Map<UUID, ChunkVisibilityManager.ChunkLoader> chunkLoaders = new HashMap<UUID, ChunkVisibilityManager.ChunkLoader>();
    public static EntityType<LinkingPortalEntity> linkingPortalEntityType;

    public static void addChunkLoader(ILinkData linkData, ServerPlayerEntity player) {
        ImmersivePortalsIntegration.removeChunkLoader(linkData, player);
        ChunkVisibilityManager.ChunkLoader chunkLoader = new ChunkVisibilityManager.ChunkLoader(new DimensionalChunkPos(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)linkData.getDimension()), new ChunkPos(linkData.getPosition())), ((Integer)ModConfig.COMMON.linkingPanelChunkLoadRadius.get()).intValue());
        chunkLoaders.put(linkData.getUUID(), chunkLoader);
        NewChunkTrackingGraph.addPerPlayerAdditionalChunkLoader((ServerPlayerEntity)player, (ChunkVisibilityManager.ChunkLoader)chunkLoader);
    }

    public static void removeChunkLoader(ILinkData linkData, ServerPlayerEntity player) {
        ChunkVisibilityManager.ChunkLoader chunkLoader = chunkLoaders.remove(linkData.getUUID());
        if (chunkLoader != null) {
            NewChunkTrackingGraph.removePerPlayerAdditionalChunkLoader((ServerPlayerEntity)player, (ChunkVisibilityManager.ChunkLoader)chunkLoader);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderGuiPortal(ILinkData linkData, Framebuffer frameBuffer, Minecraft client, MatrixStack matrixStack, int x, int y, int width, int height) {
        Matrix4f cameraTransformation = new Matrix4f();
        cameraTransformation.func_226591_a_();
        cameraTransformation.func_226596_a_(Vector3f.field_229181_d_.func_229187_a_(linkData.getRotation() + 180.0f));
        WorldRenderInfo worldRenderInfo = new WorldRenderInfo(ClientWorldLoader.getWorld((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)linkData.getDimension())), new Vector3d((double)linkData.getPosition().func_177958_n() + 0.5, (double)linkData.getPosition().func_177956_o() + 1.5, (double)linkData.getPosition().func_177952_p() + 0.5), cameraTransformation, null, ((Integer)ModConfig.COMMON.linkingPanelChunkRenderDistance.get()).intValue(), true);
        GuiPortalRendering.submitNextFrameRendering((WorldRenderInfo)worldRenderInfo, (Framebuffer)frameBuffer);
        MyRenderHelper.drawFramebuffer((Framebuffer)frameBuffer, (boolean)false, (boolean)false, (float)((float)x * (float)client.func_228018_at_().func_198100_s()), (double)((float)(x + width) * (float)client.func_228018_at_().func_198100_s()), (float)((float)y * (float)client.func_228018_at_().func_198100_s()), (double)((float)(y + height) * (float)client.func_228018_at_().func_198100_s()));
    }

    public static UUID[] addImmersivePortal(World world, double[] pos, double width, double height, Direction.Axis axis, ILinkData linkData, LinkTranslatorTileEntity tileEntity) {
        if (axis == Direction.Axis.Y) {
            return null;
        }
        ItemStack stack = ((Item)ModItems.WRITTEN_LINKING_BOOK.get()).func_190903_i();
        ILinkData itemData = (ILinkData)stack.getCapability(LinkData.LINK_DATA).orElse(null);
        itemData.setDimension(linkData.getDimension());
        itemData.setLinkEffects(linkData.getLinkEffects());
        itemData.setPosition(linkData.getPosition());
        itemData.setRotation(linkData.getRotation());
        itemData.setUUID(linkData.getUUID());
        LinkingPortalEntity portal = new LinkingPortalEntity(linkingPortalEntityType, world, stack, tileEntity.func_174877_v());
        portal.func_70107_b(pos[0], pos[1], pos[2]);
        portal.setSquareShape(axis == Direction.Axis.X ? new Vector3d(1.0, 0.0, 0.0) : new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 1.0, 0.0), width, height);
        PortalManipulation.setPortalTransformation((Portal)portal, (RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)linkData.getDimension()), (Vector3d)new Vector3d((double)linkData.getPosition().func_177958_n() + 0.5, (double)linkData.getPosition().func_177956_o() + height / 2.0, (double)linkData.getPosition().func_177952_p() + 0.5), null, (double)1.0);
        PortalManipulation.removeOverlappedPortals((World)world, (Vector3d)portal.func_242274_V(), (Vector3d)portal.getNormal(), p -> p instanceof LinkingPortalEntity, p -> {});
        world.func_217376_c((Entity)portal);
        LinkingPortalEntity reversePortal = (LinkingPortalEntity)PortalManipulation.createFlippedPortal((Portal)portal, linkingPortalEntityType);
        reversePortal.setTileEntityPos(portal.getTileEntityPos());
        PortalManipulation.removeOverlappedPortals((World)world, (Vector3d)reversePortal.func_242274_V(), (Vector3d)reversePortal.getNormal(), p -> p instanceof LinkingPortalEntity, p -> {});
        world.func_217376_c((Entity)reversePortal);
        return new UUID[]{portal.func_110124_au(), reversePortal.func_110124_au()};
    }

    @SubscribeEvent
    public static void registerImmersivePortalsEntities(RegistryEvent.Register<EntityType<?>> event) {
        linkingPortalEntityType = EntityType.Builder.func_220322_a(LinkingPortalEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.0f).setTrackingRange(96).func_220320_c().setCustomClientFactory((a, b) -> new LinkingPortalEntity(linkingPortalEntityType, (World)b)).func_206830_a("linkingbooks:linking_portal");
        linkingPortalEntityType.setRegistryName(Reference.getAsResourceLocation("linking_portal"));
        event.getRegistry().register(linkingPortalEntityType);
    }

    public static void registerEntityRenderingHandlers() {
        RenderingRegistry.registerEntityRenderingHandler(linkingPortalEntityType, PortalEntityRenderer::new);
    }

    public static List<LinkingPortalEntity> getNearbyLinkingPortals(BlockPos pos, World world) {
        return world.func_175647_a(LinkingPortalEntity.class, new AxisAlignedBB(pos.func_177979_c(64).func_177970_e(64).func_177985_f(64), pos.func_177981_b(64).func_177964_d(64).func_177965_g(64)), null);
    }

    public static void deleteLinkingPortals(LinkTranslatorTileEntity blockEntity) {
        List<LinkingPortalEntity> nearbyPortals = ImmersivePortalsIntegration.getNearbyLinkingPortals(blockEntity.func_174877_v(), blockEntity.func_145831_w());
        for (LinkingPortalEntity portal : nearbyPortals) {
            if (!portal.getTileEntityPos().equals((Object)blockEntity.func_174877_v())) continue;
            portal.func_70106_y();
        }
    }
}

