/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.block;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import thefloydman.linkingbooks.api.capability.IColorCapability;
import thefloydman.linkingbooks.api.capability.ILinkData;
import thefloydman.linkingbooks.block.LinkingPortalBlock;
import thefloydman.linkingbooks.block.ModBlocks;
import thefloydman.linkingbooks.capability.ColorCapability;
import thefloydman.linkingbooks.capability.LinkData;
import thefloydman.linkingbooks.config.ModConfig;
import thefloydman.linkingbooks.entity.LinkingBookEntity;
import thefloydman.linkingbooks.integration.ImmersivePortalsIntegration;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;
import thefloydman.linkingbooks.linking.LinkEffects;
import thefloydman.linkingbooks.tileentity.LinkTranslatorTileEntity;
import thefloydman.linkingbooks.tileentity.ModTileEntityTypes;
import thefloydman.linkingbooks.util.LinkingPortalArea;
import thefloydman.linkingbooks.util.LinkingUtils;
import thefloydman.linkingbooks.util.Reference;

public class LinkTranslatorBlock
extends HorizontalBlock {
    public static final BooleanProperty HAS_BOOK = BlockStateProperties.field_222515_o;
    public static final VoxelShape NORTH_SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)1.0), Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)4.0, (double)2.0), Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.func_208617_a((double)0.0, (double)12.0, (double)1.0, (double)16.0, (double)16.0, (double)2.0)});
    public static final VoxelShape EAST_SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)15.0, (double)4.0, (double)16.0), Block.func_208617_a((double)15.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)14.0, (double)12.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0)});
    public static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)5.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)4.0, (double)15.0), Block.func_208617_a((double)0.0, (double)11.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)12.0, (double)14.0, (double)16.0, (double)16.0, (double)15.0)});
    public static final VoxelShape WEST_SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)5.0, (double)16.0), Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)2.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.func_208617_a((double)1.0, (double)12.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0)});

    protected LinkTranslatorBlock(AbstractBlock.Properties settings) {
        super(settings);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)HAS_BOOK, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, HAS_BOOK});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.LINK_TRANSLATOR.get()).func_200968_a();
    }

    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        super.func_180633_a(world, blockPos, blockState, livingEntity, itemStack);
        for (int x = blockPos.func_177958_n() - 32; x < blockPos.func_177958_n() + 32; ++x) {
            for (int y = blockPos.func_177956_o() - 32; y < blockPos.func_177956_o() + 32; ++y) {
                for (int z = blockPos.func_177952_p() - 32; z < blockPos.func_177952_p() + 32; ++z) {
                    LinkTranslatorTileEntity translator;
                    BlockPos currentPos = new BlockPos(x, y, z);
                    TileEntity blockEntity = world.func_175625_s(currentPos);
                    if (blockEntity == null || !(blockEntity instanceof LinkTranslatorTileEntity) || !(translator = (LinkTranslatorTileEntity)blockEntity).hasBook()) continue;
                    ILinkData linkData = (ILinkData)translator.getBook().getCapability(LinkData.LINK_DATA).orElse(null);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177978_c(), Direction.Axis.X, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177978_c(), Direction.Axis.Y, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177978_c(), Direction.Axis.Z, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177968_d(), Direction.Axis.X, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177968_d(), Direction.Axis.Y, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177968_d(), Direction.Axis.Z, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177974_f(), Direction.Axis.X, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177974_f(), Direction.Axis.Y, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177974_f(), Direction.Axis.Z, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177976_e(), Direction.Axis.X, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177976_e(), Direction.Axis.Y, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177976_e(), Direction.Axis.Z, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177984_a(), Direction.Axis.X, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177984_a(), Direction.Axis.Y, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177984_a(), Direction.Axis.Z, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177977_b(), Direction.Axis.X, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177977_b(), Direction.Axis.Y, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177977_b(), Direction.Axis.Z, linkData, translator);
                }
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity generic = world.func_175625_s(pos);
        if (generic instanceof LinkTranslatorTileEntity) {
            ItemStack stack;
            Item item;
            LinkTranslatorTileEntity blockEntity = (LinkTranslatorTileEntity)generic;
            if (!world.func_201670_d() && hand.equals((Object)Hand.MAIN_HAND) && blockEntity.hasBook() && !player.func_225608_bj_() && (item = (stack = blockEntity.getBook()).func_77973_b()) instanceof WrittenLinkingBookItem) {
                ILinkData linkData = (ILinkData)stack.getCapability(LinkData.LINK_DATA).orElse(null);
                IColorCapability color = (IColorCapability)stack.getCapability(ColorCapability.COLOR).orElse(null);
                if (linkData != null && color != null) {
                    LinkingUtils.openLinkingBookGui((ServerPlayerEntity)player, false, color.getColor(), linkData, world.func_234923_W_().func_240901_a_());
                }
            }
        }
        return ActionResultType.PASS;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity;
        if (state.func_177230_c() != newState.func_177230_c() && !world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof LinkTranslatorTileEntity) {
            ItemStack stack;
            LinkTranslatorTileEntity translatorTE = (LinkTranslatorTileEntity)tileEntity;
            if (Reference.isImmersivePortalsLoaded()) {
                ImmersivePortalsIntegration.deleteLinkingPortals(translatorTE);
            }
            if (translatorTE.hasBook() && (stack = translatorTE.getBook()).func_77973_b() instanceof WrittenLinkingBookItem) {
                LinkingBookEntity entity = new LinkingBookEntity(world, stack.func_77946_l());
                entity.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, ((Direction)state.func_177229_b((Property)field_185512_D)).func_185119_l() + 180.0f, 0.0f);
                world.func_217376_c((Entity)entity);
            }
        }
        for (int x = pos.func_177958_n() - 32; x < pos.func_177958_n() + 32; ++x) {
            for (int y = pos.func_177956_o() - 32; y < pos.func_177956_o() + 32; ++y) {
                for (int z = pos.func_177952_p() - 32; z < pos.func_177952_p() + 32; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    TileEntity blockEntity = world.func_175625_s(currentPos);
                    if (blockEntity == null || !(blockEntity instanceof LinkTranslatorTileEntity)) continue;
                    LinkTranslatorTileEntity translator = (LinkTranslatorTileEntity)blockEntity;
                    if (Reference.isImmersivePortalsLoaded()) {
                        ImmersivePortalsIntegration.deleteLinkingPortals(translator);
                    }
                    if (!translator.hasBook()) continue;
                    ILinkData linkData = (ILinkData)translator.getBook().getCapability(LinkData.LINK_DATA).orElse(null);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177978_c(), Direction.Axis.X, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177978_c(), Direction.Axis.Y, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177978_c(), Direction.Axis.Z, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177968_d(), Direction.Axis.X, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177968_d(), Direction.Axis.Y, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177968_d(), Direction.Axis.Z, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177974_f(), Direction.Axis.X, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177974_f(), Direction.Axis.Y, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177974_f(), Direction.Axis.Z, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177976_e(), Direction.Axis.X, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177976_e(), Direction.Axis.Y, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177976_e(), Direction.Axis.Z, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177984_a(), Direction.Axis.X, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177984_a(), Direction.Axis.Y, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177984_a(), Direction.Axis.Z, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177977_b(), Direction.Axis.X, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177977_b(), Direction.Axis.Y, linkData, translator);
                    LinkTranslatorBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177977_b(), Direction.Axis.Z, linkData, translator);
                }
            }
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
            case EAST: {
                return EAST_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return NORTH_SHAPE;
    }

    private static void tryMakePortalWithConstantAxis(World world, BlockPos pos, Direction.Axis constantAxis, ILinkData linkData, LinkTranslatorTileEntity blockEntity) {
        if (world.func_234923_W_().func_240901_a_().equals((Object)linkData.getDimension()) && !linkData.getLinkEffects().contains(LinkEffects.INTRAAGE_LINKING.get())) {
            return;
        }
        Set<BlockPos> portalPositions = LinkingPortalArea.getPortalArea(world, pos, constantAxis, Sets.newHashSet((Object[])Stream.concat(((Block)ModBlocks.NARA.get()).func_176194_O().func_177619_a().stream(), ((Block)ModBlocks.LINK_TRANSLATOR.get()).func_176194_O().func_177619_a().stream()).collect(Collectors.toList()).toArray(new BlockState[0])), Sets.newHashSet((Object[])Blocks.field_150350_a.func_176194_O().func_177619_a().toArray((Object[])new BlockState[0])), 1, 1024);
        if (!portalPositions.isEmpty()) {
            if (Reference.isImmersivePortalsLoaded() && ((Boolean)ModConfig.COMMON.useImmersivePortalsForLinkingPortals.get()).booleanValue()) {
                double[] posAndDimensions = LinkingPortalArea.getPortalPositionAndWidthAndHeight(portalPositions);
                ImmersivePortalsIntegration.addImmersivePortal(world, new double[]{posAndDimensions[0], posAndDimensions[1], posAndDimensions[2]}, posAndDimensions[3], posAndDimensions[4], portalPositions, constantAxis, linkData, blockEntity);
            } else {
                LinkingPortalArea.createPortal(world, portalPositions, (BlockState)((Block)ModBlocks.LINKING_PORTAL.get()).func_176223_P().func_206870_a(LinkingPortalBlock.AXIS, (Comparable)constantAxis), linkData);
            }
        }
    }
}

