/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import thefloydman.linkingbooks.util.LinkingUtils;
import thefloydman.linkingbooks.world.storage.LinkingBooksSavedData;

public class LinkingPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    protected static final VoxelShape X_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Y_SHAPE = Block.func_208617_a((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    protected static final VoxelShape Z_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public LinkingPortalBlock(AbstractBlock.Properties settings) {
        super(settings);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AXIS});
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_185473_a(IBlockReader blockView, BlockPos blockPos, BlockState blockState) {
        return ItemStack.field_190927_a;
    }

    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld worldAccess, BlockPos blockPos, BlockPos blockPos2) {
        return !blockState2.func_203425_a((Block)this) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(blockState, direction, blockState2, worldAccess, blockPos, blockPos2);
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader blockView, BlockPos blockPos, ISelectionContext shapeContext) {
        switch ((Direction.Axis)blockState.func_177229_b(AXIS)) {
            case Z: {
                return Z_SHAPE;
            }
            case Y: {
                return Y_SHAPE;
            }
        }
        return X_SHAPE;
    }

    public void func_196262_a(BlockState blockState, World world, BlockPos blockPos, Entity entity) {
        if (world instanceof ServerWorld && !entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU() && VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ().func_72317_d((double)(-blockPos.func_177958_n()), (double)(-blockPos.func_177956_o()), (double)(-blockPos.func_177952_p()))), (VoxelShape)blockState.func_196954_c((IBlockReader)world, blockPos), (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
            LinkingBooksSavedData savedData = (LinkingBooksSavedData)((ServerWorld)world).func_217481_x().func_215752_a(LinkingBooksSavedData::new, "linkingbooks");
            LinkingUtils.linkEntity(entity, savedData.getLinkingPortalData(blockPos), false);
        }
    }

    public void func_196243_a(BlockState blockState, World world, BlockPos pos, BlockState blockState2, boolean bl) {
        if (blockState.func_177230_c() != blockState2.func_177230_c() && !world.func_201670_d()) {
            LinkingBooksSavedData savedData = (LinkingBooksSavedData)((ServerWorld)world).func_217481_x().func_215752_a(LinkingBooksSavedData::new, "linkingbooks");
            savedData.removeLinkingPortalData(pos);
        }
        super.func_196243_a(blockState, world, pos, blockState2, bl);
    }
}

