/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.block;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thefloydman.linkingbooks.api.capability.ILinkData;
import thefloydman.linkingbooks.block.LinkingPortalBlock;
import thefloydman.linkingbooks.block.ModBlocks;
import thefloydman.linkingbooks.capability.LinkData;
import thefloydman.linkingbooks.config.ModConfig;
import thefloydman.linkingbooks.integration.ImmersivePortalsIntegration;
import thefloydman.linkingbooks.linking.LinkEffects;
import thefloydman.linkingbooks.tileentity.LinkTranslatorTileEntity;
import thefloydman.linkingbooks.util.LinkingPortalArea;
import thefloydman.linkingbooks.util.Reference;

public class NaraBlock
extends Block {
    public NaraBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        super.func_180633_a(world, blockPos, blockState, livingEntity, itemStack);
        for (int x = blockPos.func_177958_n() - 32; x < blockPos.func_177958_n() + 32; ++x) {
            for (int y = blockPos.func_177956_o() - 32; y < blockPos.func_177956_o() + 32; ++y) {
                for (int z = blockPos.func_177952_p() - 32; z < blockPos.func_177952_p() + 32; ++z) {
                    LinkTranslatorTileEntity translator;
                    BlockPos currentPos = new BlockPos(x, y, z);
                    TileEntity blockEntity = world.func_175625_s(currentPos);
                    if (blockEntity == null || !(blockEntity instanceof LinkTranslatorTileEntity) || !(translator = (LinkTranslatorTileEntity)blockEntity).hasBook()) continue;
                    ILinkData linkData = (ILinkData)translator.getBook().getCapability(LinkData.LINK_DATA).orElse(null);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177978_c(), Direction.Axis.X, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177978_c(), Direction.Axis.Y, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177978_c(), Direction.Axis.Z, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177968_d(), Direction.Axis.X, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177968_d(), Direction.Axis.Y, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177968_d(), Direction.Axis.Z, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177974_f(), Direction.Axis.X, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177974_f(), Direction.Axis.Y, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177974_f(), Direction.Axis.Z, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177976_e(), Direction.Axis.X, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177976_e(), Direction.Axis.Y, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177976_e(), Direction.Axis.Z, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177984_a(), Direction.Axis.X, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177984_a(), Direction.Axis.Y, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177984_a(), Direction.Axis.Z, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177977_b(), Direction.Axis.X, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177977_b(), Direction.Axis.Y, linkData, translator);
                    NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177977_b(), Direction.Axis.Z, linkData, translator);
                }
            }
        }
    }

    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.func_203425_a(blockState2.func_177230_c())) {
            for (int x = blockPos.func_177958_n() - 32; x < blockPos.func_177958_n() + 32; ++x) {
                for (int y = blockPos.func_177956_o() - 32; y < blockPos.func_177956_o() + 32; ++y) {
                    for (int z = blockPos.func_177952_p() - 32; z < blockPos.func_177952_p() + 32; ++z) {
                        BlockPos currentPos = new BlockPos(x, y, z);
                        TileEntity blockEntity = world.func_175625_s(currentPos);
                        if (blockEntity == null || !(blockEntity instanceof LinkTranslatorTileEntity)) continue;
                        LinkTranslatorTileEntity translator = (LinkTranslatorTileEntity)blockEntity;
                        if (Reference.isImmersivePortalsLoaded()) {
                            ImmersivePortalsIntegration.deleteLinkingPortals(translator);
                        }
                        if (!translator.hasBook()) continue;
                        ILinkData linkData = (ILinkData)translator.getBook().getCapability(LinkData.LINK_DATA).orElse(null);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177978_c(), Direction.Axis.X, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177978_c(), Direction.Axis.Y, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177978_c(), Direction.Axis.Z, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177968_d(), Direction.Axis.X, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177968_d(), Direction.Axis.Y, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177968_d(), Direction.Axis.Z, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177974_f(), Direction.Axis.X, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177974_f(), Direction.Axis.Y, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177974_f(), Direction.Axis.Z, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177976_e(), Direction.Axis.X, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177976_e(), Direction.Axis.Y, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177976_e(), Direction.Axis.Z, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177984_a(), Direction.Axis.X, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177984_a(), Direction.Axis.Y, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177984_a(), Direction.Axis.Z, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177977_b(), Direction.Axis.X, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177977_b(), Direction.Axis.Y, linkData, translator);
                        NaraBlock.tryMakePortalWithConstantAxis(world, currentPos.func_177977_b(), Direction.Axis.Z, linkData, translator);
                    }
                }
            }
        }
        super.func_196243_a(blockState, world, blockPos, blockState2, bl);
    }

    private static void tryMakePortalWithConstantAxis(World world, BlockPos pos, Direction.Axis constantAxis, ILinkData linkData, LinkTranslatorTileEntity blockEntity) {
        if (world.func_234923_W_().func_240901_a_().equals((Object)linkData.getDimension()) && !linkData.getLinkEffects().contains(LinkEffects.INTRAAGE_LINKING.get())) {
            return;
        }
        Set<BlockPos> portalPositions = LinkingPortalArea.getPortalArea(world, pos, constantAxis, Sets.newHashSet((Object[])Stream.concat(((Block)ModBlocks.NARA.get()).func_176194_O().func_177619_a().stream(), ((Block)ModBlocks.LINK_TRANSLATOR.get()).func_176194_O().func_177619_a().stream()).collect(Collectors.toList()).toArray(new BlockState[0])), Sets.newHashSet((Object[])Blocks.field_150350_a.func_176194_O().func_177619_a().toArray((Object[])new BlockState[0])), 1, 1024);
        if (!portalPositions.isEmpty()) {
            if (Reference.isImmersivePortalsLoaded() && ((Boolean)ModConfig.COMMON.useImmersivePortalsForLinkingPortals.get()).booleanValue()) {
                double[] posAndDimensions = LinkingPortalArea.getPortalPositionAndWidthAndHeight(portalPositions);
                ImmersivePortalsIntegration.addImmersivePortal(world, new double[]{posAndDimensions[0], posAndDimensions[1], posAndDimensions[2]}, posAndDimensions[3], posAndDimensions[4], portalPositions, constantAxis, linkData, blockEntity);
            } else {
                LinkingPortalArea.createPortal(world, portalPositions, (BlockState)((Block)ModBlocks.LINKING_PORTAL.get()).func_176223_P().func_206870_a(LinkingPortalBlock.AXIS, (Comparable)constantAxis), linkData);
            }
        }
    }
}

