/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.capability;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import thefloydman.linkingbooks.api.capability.ILinkData;
import thefloydman.linkingbooks.api.linking.LinkEffect;
import thefloydman.linkingbooks.util.Reference;

public class LinkData {
    @CapabilityInject(value=ILinkData.class)
    public static final Capability<ILinkData> LINK_DATA = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(ILinkData.class, (Capability.IStorage)new Storage(), Default::new);
    }

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        private LazyOptional<ILinkData> instance = LazyOptional.of(() -> (ILinkData)LINK_DATA.getDefaultInstance());

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap.equals(LINK_DATA) && LINK_DATA != null) {
                return this.instance.cast();
            }
            return LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return LINK_DATA.getStorage().writeNBT(LINK_DATA, this.instance.orElse(LINK_DATA.getDefaultInstance()), null);
        }

        public void deserializeNBT(INBT nbt) {
            LINK_DATA.getStorage().readNBT(LINK_DATA, this.instance.orElse(LINK_DATA.getDefaultInstance()), null, nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<ILinkData> {
        @Nullable
        public INBT writeNBT(Capability<ILinkData> capability, ILinkData instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("dimension", instance.getDimension() == null ? "minecraft:overworld" : instance.getDimension().toString());
            nbt.func_218657_a("position", (INBT)NBTUtil.func_186859_a((BlockPos)(instance.getPosition() == null ? new BlockPos(0, 0, 0) : instance.getPosition())));
            nbt.func_74776_a("rotation", instance.getRotation());
            ListNBT effectsList = new ListNBT();
            for (LinkEffect effect : instance.getLinkEffects()) {
                effectsList.add((Object)StringNBT.func_229705_a_((String)effect.getRegistryName().toString()));
            }
            nbt.func_186854_a("uuid", instance.getUUID());
            nbt.func_218657_a("effects", (INBT)effectsList);
            return nbt;
        }

        public void readNBT(Capability<ILinkData> capability, ILinkData instance, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                CompoundNBT compound = (CompoundNBT)nbt;
                if (compound.func_150297_b("dimension", 8)) {
                    instance.setDimension(new ResourceLocation(compound.func_74779_i("dimension")));
                }
                if (compound.func_150297_b("position", 10)) {
                    instance.setPosition(NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("position")));
                }
                if (compound.func_150297_b("rotation", 5)) {
                    instance.setRotation(compound.func_74760_g("rotation"));
                }
                if (compound.func_150297_b("uuid", 11)) {
                    instance.setUUID(compound.func_186857_a("uuid"));
                }
                if (compound.func_150297_b("effects", 9)) {
                    for (INBT item : compound.func_150295_c("effects", 8)) {
                        instance.addLinkEffect(LinkEffect.getFromResourceLocation(new ResourceLocation(((StringNBT)item).func_150285_a_())));
                    }
                }
            }
        }
    }

    public static class Default
    implements ILinkData {
        private ResourceLocation dimension = new ResourceLocation("minecraft:overworld");
        private BlockPos position = Reference.server == null ? BlockPos.field_177992_a : Reference.server.func_241755_D_().func_241135_u_();
        private float rotation = 0.0f;
        private UUID uuid = UUID.randomUUID();
        private Set<LinkEffect> linkEffects = new HashSet<LinkEffect>();

        @Override
        public void setDimension(ResourceLocation dimension) {
            this.dimension = dimension;
        }

        @Override
        public ResourceLocation getDimension() {
            return this.dimension;
        }

        @Override
        public void setPosition(BlockPos position) {
            this.position = position;
        }

        @Override
        public BlockPos getPosition() {
            return this.position;
        }

        @Override
        public void setRotation(float rotation) {
            this.rotation = rotation;
        }

        @Override
        public float getRotation() {
            return this.rotation;
        }

        @Override
        public void setUUID(UUID uuid) {
            this.uuid = uuid;
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public void setLinkEffects(Set<LinkEffect> effects) {
            this.linkEffects = effects;
        }

        @Override
        public Set<LinkEffect> getLinkEffects() {
            return this.linkEffects;
        }

        @Override
        public boolean addLinkEffect(LinkEffect effect) {
            return this.getLinkEffects().add(effect);
        }

        @Override
        public boolean removeLinkEffect(LinkEffect effect) {
            return this.getLinkEffects().remove((Object)effect);
        }

        @Override
        public PacketBuffer write(PacketBuffer buffer) {
            CompoundNBT compound = (CompoundNBT)LINK_DATA.getStorage().writeNBT(LINK_DATA, (Object)this, null);
            buffer.func_150786_a(compound);
            return buffer;
        }

        @Override
        public void read(PacketBuffer buffer) {
            LINK_DATA.getStorage().readNBT(LINK_DATA, (Object)this, null, (INBT)buffer.func_150793_b());
        }
    }
}

