/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import thefloydman.linkingbooks.api.capability.IColorCapability;
import thefloydman.linkingbooks.block.LinkTranslatorBlock;
import thefloydman.linkingbooks.capability.ColorCapability;
import thefloydman.linkingbooks.client.renderer.entity.model.LinkingBookCoverModel;
import thefloydman.linkingbooks.client.renderer.entity.model.LinkingBookPagesModel;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;
import thefloydman.linkingbooks.tileentity.LinkTranslatorTileEntity;
import thefloydman.linkingbooks.util.Reference;

public class LinkTranslatorRenderer
extends TileEntityRenderer<LinkTranslatorTileEntity> {
    private LinkingBookCoverModel coverModel = new LinkingBookCoverModel();
    private LinkingBookPagesModel pagesModel = new LinkingBookPagesModel();
    private float[] color = new float[]{1.0f, 1.0f, 1.0f};

    public LinkTranslatorRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.coverModel.setBookState(0.95f);
        this.pagesModel.setBookState(0.95f);
    }

    public void render(LinkTranslatorTileEntity tileEntity, float arg1, MatrixStack matrixStack, IRenderTypeBuffer buffer, int arg4, int arg5) {
        if (tileEntity.hasBook()) {
            IColorCapability color;
            Item item;
            ItemStack bookStack = tileEntity.getBook();
            if (bookStack != null && !bookStack.func_190926_b() && (item = bookStack.func_77973_b()) != null && item instanceof WrittenLinkingBookItem && (color = (IColorCapability)bookStack.getCapability(ColorCapability.COLOR).orElse(null)) != null) {
                this.color = new Color(color.getColor()).getRGBColorComponents(this.color);
            }
            matrixStack.func_227860_a_();
            float rotation = 0.0f;
            double[] translate = new double[]{0.0, 0.0, 0.0};
            switch ((Direction)tileEntity.func_195044_w().func_177229_b((Property)LinkTranslatorBlock.field_185512_D)) {
                case NORTH: {
                    rotation = 1.0f;
                    translate[0] = 0.5;
                    translate[1] = 0.5;
                    translate[2] = 0.115;
                    break;
                }
                case WEST: {
                    rotation = 2.0f;
                    translate[0] = 0.115;
                    translate[1] = 0.5;
                    translate[2] = 0.5;
                    break;
                }
                case SOUTH: {
                    rotation = 3.0f;
                    translate[0] = 0.5;
                    translate[1] = 0.5;
                    translate[2] = 0.885;
                    break;
                }
                case EAST: {
                    rotation = 0.0f;
                    translate[0] = 0.885;
                    translate[1] = 0.5;
                    translate[2] = 0.5;
                    break;
                }
                default: {
                    rotation = 1.0f;
                    translate[0] = 0.5;
                    translate[1] = 0.5;
                    translate[2] = 0.4;
                }
            }
            matrixStack.func_227861_a_(translate[0], translate[1], translate[2]);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)Math.PI * rotation / 2.0f));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_((float)Math.PI));
            matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
            IVertexBuilder vertexBuilder = buffer.getBuffer(this.coverModel.func_228282_a_(Reference.Resources.LINKING_BOOK_TEXTURE));
            this.coverModel.func_225598_a_(matrixStack, vertexBuilder, Short.MAX_VALUE, arg5, this.color[0], this.color[1], this.color[2], 1.0f);
            this.pagesModel.func_225598_a_(matrixStack, vertexBuilder, Short.MAX_VALUE, arg5, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.func_227865_b_();
        }
    }
}

