/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.event;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import thefloydman.linkingbooks.api.capability.ILinkData;
import thefloydman.linkingbooks.block.LinkTranslatorBlock;
import thefloydman.linkingbooks.block.LinkingLecternBlock;
import thefloydman.linkingbooks.block.LinkingPortalBlock;
import thefloydman.linkingbooks.block.MarkerSwitchBlock;
import thefloydman.linkingbooks.block.ModBlocks;
import thefloydman.linkingbooks.capability.LinkData;
import thefloydman.linkingbooks.command.LinkCommand;
import thefloydman.linkingbooks.config.ModConfig;
import thefloydman.linkingbooks.entity.LinkingBookEntity;
import thefloydman.linkingbooks.integration.ImmersivePortalsIntegration;
import thefloydman.linkingbooks.item.WrittenLinkingBookItem;
import thefloydman.linkingbooks.linking.LinkEffects;
import thefloydman.linkingbooks.tileentity.LinkTranslatorTileEntity;
import thefloydman.linkingbooks.tileentity.LinkingBookHolderTileEntity;
import thefloydman.linkingbooks.tileentity.MarkerSwitchTileEntity;
import thefloydman.linkingbooks.util.LinkingPortalArea;
import thefloydman.linkingbooks.util.Reference;

@Mod.EventBusSubscriber(modid="linkingbooks", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    @SubscribeEvent
    public static void tossItem(ItemTossEvent event) {
        ItemStack stack = event.getEntityItem().func_92059_d();
        if (stack.func_77973_b() instanceof WrittenLinkingBookItem) {
            event.setCanceled(true);
            PlayerEntity player = event.getPlayer();
            World world = event.getEntity().func_130014_f_();
            LinkingBookEntity entity = new LinkingBookEntity(world, stack.func_77946_l());
            Vector3d lookVec = player.func_70040_Z();
            entity.func_70107_b(player.func_226277_ct_() + lookVec.func_82615_a(), player.func_226278_cu_() + 1.75 + lookVec.func_82617_b(), player.func_226281_cx_() + lookVec.func_82616_c());
            entity.field_70177_z = player.field_70759_as;
            entity.func_70024_g(lookVec.field_72450_a / 4.0, lookVec.field_72448_b / 4.0, lookVec.field_72449_c / 4.0);
            world.func_217376_c((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void attachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
    }

    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
    }

    @SubscribeEvent
    public static void attachTileEntityCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
    }

    @SubscribeEvent
    public static void serverStarting(FMLServerStartingEvent event) {
        LinkCommand.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
    }

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        TileEntity generic;
        BlockState state;
        World world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        if (world.func_201670_d() || hand.equals((Object)Hand.OFF_HAND) || !player.func_225608_bj_()) {
            return;
        }
        BlockPos pos = event.getPos();
        if (world.func_180495_p(pos).func_177230_c() instanceof LinkingLecternBlock || world.func_180495_p(pos).func_177230_c() instanceof LinkTranslatorBlock) {
            TileEntity generic2 = world.func_175625_s(pos);
            if (!(generic2 instanceof LinkingBookHolderTileEntity)) {
                return;
            }
            LinkingBookHolderTileEntity tileEntity = (LinkingBookHolderTileEntity)generic2;
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b() instanceof WrittenLinkingBookItem && !tileEntity.hasBook()) {
                ILinkData linkData = (ILinkData)stack.getCapability(LinkData.LINK_DATA).orElse(null);
                tileEntity.setBook(stack);
                player.field_71069_bz.func_75142_b();
                if (world.func_175625_s(pos) instanceof LinkTranslatorTileEntity) {
                    LinkTranslatorTileEntity linkTranslatorTileEntity = (LinkTranslatorTileEntity)tileEntity;
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177978_c(), Direction.Axis.X, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177978_c(), Direction.Axis.Y, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177978_c(), Direction.Axis.Z, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177968_d(), Direction.Axis.X, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177968_d(), Direction.Axis.Y, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177968_d(), Direction.Axis.Z, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177974_f(), Direction.Axis.X, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177974_f(), Direction.Axis.Y, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177974_f(), Direction.Axis.Z, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177976_e(), Direction.Axis.X, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177976_e(), Direction.Axis.Y, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177976_e(), Direction.Axis.Z, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177984_a(), Direction.Axis.X, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177984_a(), Direction.Axis.Y, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177984_a(), Direction.Axis.Z, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177977_b(), Direction.Axis.X, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177977_b(), Direction.Axis.Y, linkData, linkTranslatorTileEntity);
                    ForgeEventHandler.tryMakePortalWithConstantAxis(world, pos.func_177977_b(), Direction.Axis.Z, linkData, linkTranslatorTileEntity);
                }
            } else if (stack.func_190926_b() && tileEntity.hasBook()) {
                player.func_191521_c(tileEntity.getBook());
                player.field_71069_bz.func_75142_b();
                tileEntity.setBook(ItemStack.field_190927_a);
                if (world.func_175625_s(pos) instanceof LinkTranslatorTileEntity) {
                    LinkTranslatorTileEntity linkTranslatorBlockEntity = (LinkTranslatorTileEntity)tileEntity;
                    if (Reference.isImmersivePortalsLoaded()) {
                        ImmersivePortalsIntegration.deleteLinkingPortals(linkTranslatorBlockEntity);
                    }
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177978_c(), Direction.Axis.X);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177974_f(), Direction.Axis.X);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177976_e(), Direction.Axis.X);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177968_d(), Direction.Axis.X);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177984_a(), Direction.Axis.X);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177977_b(), Direction.Axis.X);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177978_c(), Direction.Axis.Y);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177974_f(), Direction.Axis.Y);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177976_e(), Direction.Axis.Y);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177968_d(), Direction.Axis.Y);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177984_a(), Direction.Axis.Y);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177977_b(), Direction.Axis.Y);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177978_c(), Direction.Axis.Z);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177974_f(), Direction.Axis.Z);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177976_e(), Direction.Axis.Z);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177968_d(), Direction.Axis.Z);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177984_a(), Direction.Axis.Z);
                    ForgeEventHandler.tryErasePortalWithConstantAxis(world, pos.func_177977_b(), Direction.Axis.Z);
                }
            }
        } else if (world.func_180495_p(pos).func_177230_c() instanceof MarkerSwitchBlock && ((Boolean)(state = world.func_180495_p(pos)).func_177229_b((Property)MarkerSwitchBlock.OPEN)).booleanValue() && (generic = world.func_175625_s(pos)) instanceof MarkerSwitchTileEntity) {
            MarkerSwitchTileEntity tileEntity = (MarkerSwitchTileEntity)generic;
            MarkerSwitchTileEntity twinEntity = (MarkerSwitchTileEntity)(state.func_177229_b(MarkerSwitchBlock.HALF) == DoubleBlockHalf.LOWER ? world.func_175625_s(pos.func_177984_a()) : world.func_175625_s(pos.func_177977_b()));
            ItemStack stack = player.func_184586_b(hand);
            if (tileEntity.func_191420_l()) {
                tileEntity.setItem(stack);
                twinEntity.setItem(stack);
                stack.func_190920_e(0);
                player.field_71069_bz.func_75142_b();
            } else if (tileEntity.hasItem()) {
                player.func_191521_c(tileEntity.getItem());
                player.field_71069_bz.func_75142_b();
                tileEntity.setItem(ItemStack.field_190927_a);
                twinEntity.setItem(ItemStack.field_190927_a);
            }
        }
    }

    private static void tryMakePortalWithConstantAxis(World world, BlockPos pos, Direction.Axis constantAxis, ILinkData linkData, LinkTranslatorTileEntity blockEntity) {
        if (world.func_234923_W_().func_240901_a_().equals((Object)linkData.getDimension()) && !linkData.getLinkEffects().contains(LinkEffects.INTRAAGE_LINKING.get())) {
            return;
        }
        Set<BlockPos> portalPositions = LinkingPortalArea.getPortalArea(world, pos, constantAxis, Sets.newHashSet((Object[])Stream.concat(((Block)ModBlocks.NARA.get()).func_176194_O().func_177619_a().stream(), ((Block)ModBlocks.LINK_TRANSLATOR.get()).func_176194_O().func_177619_a().stream()).collect(Collectors.toList()).toArray(new BlockState[0])), Sets.newHashSet((Object[])Blocks.field_150350_a.func_176194_O().func_177619_a().toArray((Object[])new BlockState[0])), 1, 1024);
        if (!portalPositions.isEmpty()) {
            if (Reference.isImmersivePortalsLoaded() && ((Boolean)ModConfig.COMMON.useImmersivePortalsForLinkingPortals.get()).booleanValue()) {
                double[] posAndDimensions = LinkingPortalArea.getPortalPositionAndWidthAndHeight(portalPositions);
                ImmersivePortalsIntegration.addImmersivePortal(world, new double[]{posAndDimensions[0], posAndDimensions[1], posAndDimensions[2]}, posAndDimensions[3], posAndDimensions[4], portalPositions, constantAxis, linkData, blockEntity);
            } else {
                LinkingPortalArea.createPortal(world, portalPositions, (BlockState)((Block)ModBlocks.LINKING_PORTAL.get()).func_176223_P().func_206870_a(LinkingPortalBlock.AXIS, (Comparable)constantAxis), linkData);
            }
        }
    }

    private static void tryErasePortalWithConstantAxis(World world, BlockPos pos, Direction.Axis constantAxis) {
        Set<BlockPos> portalPositions = LinkingPortalArea.getPortalArea(world, pos, constantAxis, Sets.newHashSet((Object[])Stream.concat(((Block)ModBlocks.NARA.get()).func_176194_O().func_177619_a().stream(), ((Block)ModBlocks.LINK_TRANSLATOR.get()).func_176194_O().func_177619_a().stream()).collect(Collectors.toList()).toArray(new BlockState[0])), Sets.newHashSet((Object[])((Block)ModBlocks.LINKING_PORTAL.get()).func_176194_O().func_177619_a().toArray((Object[])new BlockState[0])), 1, 1024);
        if (!portalPositions.isEmpty()) {
            LinkingPortalArea.erasePortal(world, portalPositions);
        }
    }

    @SubscribeEvent
    public static void onServerStarted(FMLServerStartedEvent event) {
        Reference.server = event.getServer();
    }
}

