/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import thefloydman.linkingbooks.api.capability.ILinkData;
import thefloydman.linkingbooks.world.storage.LinkingBooksSavedData;

public class LinkingPortalArea {
    public static Set<BlockPos> getPortalArea(World world, BlockPos startFillerPos, Direction.Axis constantAxis, Set<BlockState> validFrameStates, Set<BlockState> validFillerStates, int minArea, int maxArea) {
        if (world == null || startFillerPos == null || validFrameStates == null || validFillerStates == null || !validFillerStates.contains(world.func_180495_p(startFillerPos))) {
            return new HashSet<BlockPos>();
        }
        ArrayList<BlockPos> unvisited = new ArrayList<BlockPos>();
        unvisited.add(startFillerPos);
        HashSet<BlockPos> frame = new HashSet<BlockPos>();
        HashSet<BlockPos> filler = new HashSet<BlockPos>();
        while (unvisited.size() > 0) {
            BlockPos currentPos = (BlockPos)unvisited.get(0);
            unvisited.remove(0);
            if (validFrameStates.contains(world.func_180495_p(currentPos))) {
                frame.add(currentPos);
            } else if (validFillerStates.contains(world.func_180495_p(currentPos))) {
                filler.add(currentPos);
                switch (constantAxis) {
                    case Y: {
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.func_177978_c(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.func_177974_f(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.func_177968_d(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.func_177976_e(), frame, filler);
                        break;
                    }
                    case Z: {
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.func_177984_a(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.func_177977_b(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.func_177978_c(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.func_177968_d(), frame, filler);
                        break;
                    }
                    default: {
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.func_177984_a(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.func_177977_b(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.func_177974_f(), frame, filler);
                        LinkingPortalArea.addPosIfAbsent(unvisited, currentPos.func_177976_e(), frame, filler);
                        break;
                    }
                }
            } else {
                return new HashSet<BlockPos>();
            }
            if (filler.size() <= maxArea) continue;
            return new HashSet<BlockPos>();
        }
        return filler.size() < minArea ? new HashSet<BlockPos>() : filler;
    }

    private static void addPosIfAbsent(List<BlockPos> unvisited, BlockPos pos, Set<BlockPos> frame, Set<BlockPos> filler) {
        if (!(unvisited.contains(pos) || frame.contains(pos) || filler.contains(pos))) {
            unvisited.add(pos);
        }
    }

    public static void createPortal(World world, Set<BlockPos> positions, BlockState portalState, ILinkData linkData) {
        for (BlockPos pos : positions) {
            world.func_180501_a(pos, portalState, 18);
            if (!(world instanceof ServerWorld) || linkData == null) continue;
            LinkingBooksSavedData savedData = (LinkingBooksSavedData)((ServerWorld)world).func_217481_x().func_215752_a(LinkingBooksSavedData::new, "linkingbooks");
            savedData.addLinkingPortalData(pos, linkData);
        }
    }

    public static void erasePortal(World world, Set<BlockPos> positions) {
        BlockState blockState = Blocks.field_150350_a.func_176223_P();
        for (BlockPos pos : positions) {
            world.func_180501_a(pos, blockState, 18);
            world.func_180501_a(pos, blockState, 18);
            if (!(world instanceof ServerWorld)) continue;
            LinkingBooksSavedData savedData = (LinkingBooksSavedData)((ServerWorld)world).func_217481_x().func_215752_a(LinkingBooksSavedData::new, "linkingbooks");
            savedData.removeLinkingPortalData(pos);
        }
    }

    public static double[] getPortalPositionAndWidthAndHeight(Set<BlockPos> positions) {
        double xMin = ((Integer)Collections.min(positions.stream().map(pos -> pos.func_177958_n()).collect(Collectors.toSet()))).intValue();
        double xMax = ((Integer)Collections.max(positions.stream().map(pos -> pos.func_177958_n()).collect(Collectors.toSet()))).intValue();
        double posX = (xMin + xMax) / 2.0;
        double deltaX = xMax - xMin;
        double yMin = ((Integer)Collections.min(positions.stream().map(pos -> pos.func_177956_o()).collect(Collectors.toSet()))).intValue();
        double yMax = ((Integer)Collections.max(positions.stream().map(pos -> pos.func_177956_o()).collect(Collectors.toSet()))).intValue();
        double posY = (yMin + yMax) / 2.0;
        double deltaY = yMax - yMin;
        double zMin = ((Integer)Collections.min(positions.stream().map(pos -> pos.func_177952_p()).collect(Collectors.toSet()))).intValue();
        double zMax = ((Integer)Collections.max(positions.stream().map(pos -> pos.func_177952_p()).collect(Collectors.toSet()))).intValue();
        double posZ = (zMin + zMax) / 2.0;
        double deltaZ = zMax - zMin;
        double width = 0.0;
        double height = 0.0;
        if (deltaY != 0.0) {
            width = deltaX != 0.0 ? deltaX : deltaZ;
            height = deltaY;
        } else {
            width = deltaZ;
            height = deltaX;
        }
        return new double[]{posX, posY, posZ, width, height};
    }
}

