/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.linkingbooks.world.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.storage.WorldSavedData;
import thefloydman.linkingbooks.api.capability.ILinkData;
import thefloydman.linkingbooks.capability.LinkData;
import thefloydman.linkingbooks.item.ModItems;

public class LinkingBooksSavedData
extends WorldSavedData {
    private Map<UUID, CompoundNBT> linkingPanelImages = new HashMap<UUID, CompoundNBT>();
    private Map<BlockPos, ILinkData> linkingPortals = new HashMap<BlockPos, ILinkData>();

    public LinkingBooksSavedData() {
        super("linkingbooks");
    }

    public LinkingBooksSavedData(String s) {
        super(s);
    }

    public boolean addLinkingPanelImage(UUID uuid, CompoundNBT image) {
        if (this.linkingPanelImages.containsKey(uuid)) {
            return false;
        }
        this.linkingPanelImages.put(uuid, image);
        this.func_76185_a();
        return true;
    }

    public boolean removeLinkingPanelImage(UUID uuid) {
        if (!this.linkingPanelImages.containsKey(uuid)) {
            return false;
        }
        this.linkingPanelImages.remove(uuid);
        this.func_76185_a();
        return true;
    }

    public CompoundNBT getLinkingPanelImage(UUID uuid) {
        return this.linkingPanelImages.get(uuid);
    }

    public boolean addLinkingPortalData(BlockPos pos, ILinkData linkData) {
        this.linkingPortals.put(new BlockPos((Vector3i)pos), linkData);
        this.func_76185_a();
        return true;
    }

    public boolean removeLinkingPortalData(BlockPos pos) {
        if (!this.linkingPortals.containsKey(pos)) {
            return false;
        }
        this.linkingPortals.remove(pos);
        this.func_76185_a();
        return true;
    }

    public ILinkData getLinkingPortalData(BlockPos pos) {
        return this.linkingPortals.get(pos);
    }

    public void func_76184_a(CompoundNBT nbt) {
        CompoundNBT compound;
        ListNBT list;
        if (nbt.func_150297_b("linkingPanelImages", 9)) {
            list = nbt.func_150295_c("linkingPanelImages", 10);
            for (INBT item : list) {
                compound = (CompoundNBT)item;
                if (!compound.func_150297_b("uuid", 11)) continue;
                UUID uuid = compound.func_186857_a("uuid");
                this.linkingPanelImages.put(uuid, compound);
            }
        }
        if (nbt.func_150297_b("linking_portals", 9)) {
            list = nbt.func_150295_c("linking_portals", 10);
            for (INBT item : list) {
                compound = (CompoundNBT)item;
                BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("portal_pos"));
                ILinkData linkData = (ILinkData)((Item)ModItems.WRITTEN_LINKING_BOOK.get()).func_190903_i().getCapability(LinkData.LINK_DATA).orElse(null);
                LinkData.LINK_DATA.readNBT((Object)linkData, null, (INBT)compound.func_74775_l("link_data"));
                this.linkingPortals.put(pos, linkData);
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        ListNBT imageList = new ListNBT();
        this.linkingPanelImages.forEach((uuid, image) -> {
            image.func_186854_a("uuid", uuid);
            imageList.add(image);
        });
        nbt.func_218657_a("linkingPanelImages", (INBT)imageList);
        ListNBT portalList = new ListNBT();
        this.linkingPortals.forEach((pos, linkData) -> {
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("portal_pos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
            compound.func_218657_a("link_data", LinkData.LINK_DATA.getStorage().writeNBT(LinkData.LINK_DATA, linkData, null));
            portalList.add((Object)compound);
        });
        nbt.func_218657_a("linking_portals", (INBT)portalList);
        return nbt;
    }
}

