/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.storage;

import com.mcwfurnitures.kikoz.init.EntityInit;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;

public class ChairEntity
extends Entity {
    private BlockPos chair;

    public ChairEntity(EntityType<? extends ChairEntity> type, Level level) {
        super(type, level);
        this.noPhysics = true;
    }

    private ChairEntity(Level level, BlockPos pos, double yOffset) {
        this((EntityType<? extends ChairEntity>)((EntityType)EntityInit.CHAIR.get()), level);
        this.chair = pos;
        this.setPos((double)this.chair.getX() + 0.5, (double)this.chair.getY() + 0.7, (double)this.chair.getZ() + 0.5);
    }

    protected void readAdditionalSaveData(ValueInput tag) {
    }

    protected void addAdditionalSaveData(ValueOutput tag) {
    }

    protected boolean canRide(Entity entity) {
        return true;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && (this.getPassengers().isEmpty() || this.level().isEmptyBlock(this.blockPosition()))) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float v) {
        return false;
    }

    public static InteractionResult create(Level level, BlockPos pos, double doub, Player player) {
        List seatsInThisBlock;
        if (!level.isClientSide() && (seatsInThisBlock = level.getEntitiesOfClass(ChairEntity.class, new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + 1.0, (double)pos.getZ() + 1.0))).isEmpty()) {
            ChairEntity chair = new ChairEntity(level, pos, doub);
            level.addFreshEntity((Entity)chair);
            player.startRiding((Entity)chair);
        }
        return InteractionResult.SUCCESS;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }
}

