/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects.counters;

import com.mcwfurnitures.kikoz.objects.counters.Counter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SinkCounter
extends Counter {
    public static final BooleanProperty WATER = BooleanProperty.create((String)"water");
    protected static final VoxelShape BASE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);

    public SinkCounter(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATER, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = itemstack.getItem();
        boolean hasWater = (Boolean)state.getValue((Property)WATER);
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (item == Items.WATER_BUCKET && !hasWater) {
            state = (BlockState)state.cycle((Property)WATER);
            level.setBlock(pos, state, 2);
            level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
            return InteractionResult.SUCCESS;
        }
        if (item == Items.BUCKET && hasWater) {
            state = (BlockState)state.cycle((Property)WATER);
            level.setBlock(pos, state, 2);
            itemstack.shrink(1);
            level.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.WATER_BUCKET));
            return InteractionResult.SUCCESS;
        }
        if (item == Items.GLASS_BOTTLE && hasWater) {
            state = (BlockState)state.cycle((Property)WATER);
            level.setBlock(pos, state, 2);
            level.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemStack waterBottle = new ItemStack((ItemLike)Items.POTION);
            CompoundTag tag = new CompoundTag();
            tag.putString("Potion", "minecraft:water");
            waterBottle.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER));
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
                if (itemstack.isEmpty()) {
                    player.setItemInHand(hand, waterBottle);
                } else if (!player.getInventory().add(waterBottle)) {
                    player.drop(waterBottle, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide) {
            BlockState newState = (BlockState)state.cycle((Property)WATER);
            level.setBlock(pos, newState, 3);
            level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!hasWater) {
            double baseX = (double)pos.getX() + 0.5;
            double baseZ = (double)pos.getZ() + 0.5;
            double offset = 0.1;
            switch (facing) {
                case NORTH: {
                    baseZ -= offset;
                    break;
                }
                case SOUTH: {
                    baseZ += offset;
                    break;
                }
                case EAST: {
                    baseX += offset;
                    break;
                }
                case WEST: {
                    baseX -= offset;
                }
            }
            for (int i = 0; i < 20; ++i) {
                double y = (double)(pos.getY() + 1) - (double)i * 0.001;
                level.addParticle((ParticleOptions)ParticleTypes.FALLING_DRIPSTONE_WATER, baseX, y, baseZ, 0.0, -1.0E-4, 0.0);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATER});
    }
}

