/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.storage;

import com.mcwfurnitures.kikoz.init.BlockEntityInit;
import com.mcwfurnitures.kikoz.init.SoundsInit;
import com.mcwfurnitures.kikoz.objects.TallFurniture;
import com.mcwfurnitures.kikoz.objects.bookshelves.BookCabinet;
import com.mcwfurnitures.kikoz.objects.bookshelves.BookCabinetHinge;
import com.mcwfurnitures.kikoz.objects.cabinets.Cabinet;
import com.mcwfurnitures.kikoz.objects.cabinets.CabinetHinge;
import com.mcwfurnitures.kikoz.objects.counters.CupboardCounter;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;

public class StorageTileEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            if (state.getBlock() instanceof TallFurniture || state.getBlock() instanceof BookCabinet || state.getBlock() instanceof BookCabinetHinge || state.getBlock() instanceof Cabinet || state.getBlock() instanceof CabinetHinge || state.getBlock() instanceof CupboardCounter) {
                this.playSound(null, level, pos, true, (SoundEvent)SoundsInit.CABINET_OPEN.get(), 0.5f);
            } else {
                this.playSound(null, level, pos, true, (SoundEvent)SoundsInit.DRAWER_OPEN.get(), 0.5f);
            }
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            if (state.getBlock() instanceof TallFurniture || state.getBlock() instanceof BookCabinet || state.getBlock() instanceof BookCabinetHinge || state.getBlock() instanceof Cabinet || state.getBlock() instanceof CabinetHinge || state.getBlock() instanceof CupboardCounter) {
                this.playSound(null, level, pos, false, (SoundEvent)SoundsInit.CABINET_CLOSE.get(), 0.5f);
            } else {
                this.playSound(null, level, pos, false, (SoundEvent)SoundsInit.DRAWER_CLOSE.get(), 0.5f);
            }
        }

        private void playSound(@Nullable Entity entity, Level level, BlockPos pos, boolean open, SoundEvent sound, float volume) {
            level.playSound(entity, pos, sound, SoundSource.BLOCKS, volume, level.random.nextFloat() * 0.1f + 0.9f);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int num, int num2) {
        }

        public boolean isOwnContainer(Player player) {
            if (player.containerMenu instanceof ChestMenu) {
                Container container = ((ChestMenu)player.containerMenu).getContainer();
                return container == StorageTileEntity.this;
            }
            return false;
        }
    };
    private final ItemStacksResourceHandler itemHandler = new ItemStacksResourceHandler(27){

        protected ItemStack getStack(int slot) {
            return (ItemStack)StorageTileEntity.this.items.get(slot);
        }

        protected void setStack(int slot, ItemStack stack) {
            StorageTileEntity.this.items.set(slot, (Object)stack);
            StorageTileEntity.this.setChanged();
        }

        public boolean isValid(int slot, ItemResource resource) {
            return true;
        }
    };

    public StorageTileEntity(BlockPos pos, BlockState state) {
        super(BlockEntityInit.FURNITURE_STORAGE.get(), pos, state);
    }

    public ResourceHandler<ItemResource> getItemHandler() {
        return this.itemHandler;
    }

    protected void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((ValueOutput)tag, this.items);
        }
    }

    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((ValueInput)tag, this.items);
        }
    }

    public int getContainerSize() {
        return 27;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> stack) {
        this.items = stack;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"mcwfurnitures.container.threerows");
    }

    protected AbstractContainerMenu createMenu(int ints, Inventory inventory) {
        return ChestMenu.threeRows((int)ints, (Inventory)inventory, (Container)this);
    }

    public void startOpen(ContainerUser user) {
        if (!this.remove && !user.getLivingEntity().isSpectator()) {
            this.openersCounter.incrementOpeners(user.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState(), user.getContainerInteractionRange());
        }
    }

    public void stopOpen(ContainerUser user) {
        if (!this.remove && !user.getLivingEntity().isSpectator()) {
            this.openersCounter.decrementOpeners(user.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    void updateBlockState(BlockState state, boolean bool) {
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(bool)), 3);
    }
}

