/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz;

import com.mcwfurnitures.kikoz.init.BlockInit;
import com.mcwfurnitures.kikoz.init.ContainerTypesInit;
import com.mcwfurnitures.kikoz.init.EntityInit;
import com.mcwfurnitures.kikoz.init.ItemInit;
import com.mcwfurnitures.kikoz.init.SoundsInit;
import com.mcwfurnitures.kikoz.init.TileEntityInit;
import com.mcwfurnitures.kikoz.objects.ItemBlock;
import com.mcwfurnitures.kikoz.storage.ChairRender;
import com.mcwfurnitures.kikoz.storage.CouchRenderer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="mcwfurnitures")
@Mod.EventBusSubscriber(modid="mcwfurnitures", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MacawsFurnitures {
    public static final String MOD_ID = "mcwfurnitures";
    public static MacawsFurnitures instance;
    public static final ItemGroup FurnitureItemGroup;

    public MacawsFurnitures() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::doClientStuff);
        BlockInit.BLOCKS.register(modEventBus);
        ItemInit.ITEMS.register(modEventBus);
        TileEntityInit.TILE_ENTITY_TYPES.register(modEventBus);
        ContainerTypesInit.CONTAINER_TYPES.register(modEventBus);
        SoundsInit.SOUNDS.register(modEventBus);
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        BlockInit.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            Item.Properties properties = new Item.Properties().func_200916_a(FurnitureItemGroup);
            ItemBlock blockItem = new ItemBlock((Block)block, properties);
            blockItem.setRegistryName(block.getRegistryName());
            registry.register((IForgeRegistryEntry)blockItem);
        });
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityInit.SITTABLE_BLOCK, ChairRender::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityInit.COUCH, CouchRenderer::new);
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    public static VoxelShape calculateShapes(Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, VoxelShapes.func_197880_a()};
        int times = (to.func_176736_b() - Direction.NORTH.func_176736_b() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = VoxelShapes.func_197872_a((VoxelShape)buffer[1], (VoxelShape)VoxelShapes.func_197873_a((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = VoxelShapes.func_197880_a();
        }
        return buffer[0];
    }

    static {
        FurnitureItemGroup = new ItemGroup("furnitures"){

            @Nonnull
            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)BlockInit.OAK_WARDROBE.get());
            }
        };
    }

    public static class Entity {
        public static final String SITTABLE_BLOCK = "mcwfurnitures:sittable_block";
        public static final String COUCH = "mcwfurnitures:couch";
    }
}

